import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasApiKeysConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/api_keys#id DataMongodbatlasApiKeys#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/api_keys#items_per_page DataMongodbatlasApiKeys#items_per_page}
    */
    readonly itemsPerPage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/api_keys#org_id DataMongodbatlasApiKeys#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/api_keys#page_num DataMongodbatlasApiKeys#page_num}
    */
    readonly pageNum?: number;
}
export interface DataMongodbatlasApiKeysResults {
}
export declare function dataMongodbatlasApiKeysResultsToTerraform(struct?: DataMongodbatlasApiKeysResults): any;
export declare class DataMongodbatlasApiKeysResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasApiKeysResults | undefined;
    set internalValue(value: DataMongodbatlasApiKeysResults | undefined);
    get apiKeyId(): string;
    get description(): string;
    get publicKey(): string;
    get roleNames(): string[];
}
export declare class DataMongodbatlasApiKeysResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasApiKeysResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/api_keys mongodbatlas_api_keys}
*/
export declare class DataMongodbatlasApiKeys extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_api_keys";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/api_keys mongodbatlas_api_keys} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasApiKeysConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasApiKeysConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _itemsPerPage?;
    get itemsPerPage(): number;
    set itemsPerPage(value: number);
    resetItemsPerPage(): void;
    get itemsPerPageInput(): number | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _pageNum?;
    get pageNum(): number;
    set pageNum(value: number);
    resetPageNum(): void;
    get pageNumInput(): number | undefined;
    private _results;
    get results(): DataMongodbatlasApiKeysResultsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
