import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasCloudBackupScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_schedule#cluster_name DataMongodbatlasCloudBackupSchedule#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_schedule#id DataMongodbatlasCloudBackupSchedule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_schedule#project_id DataMongodbatlasCloudBackupSchedule#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasCloudBackupScheduleCopySettings {
}
export declare function dataMongodbatlasCloudBackupScheduleCopySettingsToTerraform(struct?: DataMongodbatlasCloudBackupScheduleCopySettings): any;
export declare class DataMongodbatlasCloudBackupScheduleCopySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupScheduleCopySettings | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupScheduleCopySettings | undefined);
    get cloudProvider(): string;
    get frequencies(): string[];
    get regionName(): string;
    get replicationSpecId(): string;
    get shouldCopyOplogs(): cdktf.IResolvable;
}
export declare class DataMongodbatlasCloudBackupScheduleCopySettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupScheduleCopySettingsOutputReference;
}
export interface DataMongodbatlasCloudBackupScheduleExport {
}
export declare function dataMongodbatlasCloudBackupScheduleExportToTerraform(struct?: DataMongodbatlasCloudBackupScheduleExport): any;
export declare class DataMongodbatlasCloudBackupScheduleExportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupScheduleExport | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupScheduleExport | undefined);
    get exportBucketId(): string;
    get frequencyType(): string;
}
export declare class DataMongodbatlasCloudBackupScheduleExportList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupScheduleExportOutputReference;
}
export interface DataMongodbatlasCloudBackupSchedulePolicyItemDaily {
}
export declare function dataMongodbatlasCloudBackupSchedulePolicyItemDailyToTerraform(struct?: DataMongodbatlasCloudBackupSchedulePolicyItemDaily): any;
export declare class DataMongodbatlasCloudBackupSchedulePolicyItemDailyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupSchedulePolicyItemDaily | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupSchedulePolicyItemDaily | undefined);
    get frequencyInterval(): number;
    get frequencyType(): string;
    get id(): string;
    get retentionUnit(): string;
    get retentionValue(): number;
}
export declare class DataMongodbatlasCloudBackupSchedulePolicyItemDailyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupSchedulePolicyItemDailyOutputReference;
}
export interface DataMongodbatlasCloudBackupSchedulePolicyItemHourly {
}
export declare function dataMongodbatlasCloudBackupSchedulePolicyItemHourlyToTerraform(struct?: DataMongodbatlasCloudBackupSchedulePolicyItemHourly): any;
export declare class DataMongodbatlasCloudBackupSchedulePolicyItemHourlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupSchedulePolicyItemHourly | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupSchedulePolicyItemHourly | undefined);
    get frequencyInterval(): number;
    get frequencyType(): string;
    get id(): string;
    get retentionUnit(): string;
    get retentionValue(): number;
}
export declare class DataMongodbatlasCloudBackupSchedulePolicyItemHourlyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupSchedulePolicyItemHourlyOutputReference;
}
export interface DataMongodbatlasCloudBackupSchedulePolicyItemMonthly {
}
export declare function dataMongodbatlasCloudBackupSchedulePolicyItemMonthlyToTerraform(struct?: DataMongodbatlasCloudBackupSchedulePolicyItemMonthly): any;
export declare class DataMongodbatlasCloudBackupSchedulePolicyItemMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupSchedulePolicyItemMonthly | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupSchedulePolicyItemMonthly | undefined);
    get frequencyInterval(): number;
    get frequencyType(): string;
    get id(): string;
    get retentionUnit(): string;
    get retentionValue(): number;
}
export declare class DataMongodbatlasCloudBackupSchedulePolicyItemMonthlyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupSchedulePolicyItemMonthlyOutputReference;
}
export interface DataMongodbatlasCloudBackupSchedulePolicyItemWeekly {
}
export declare function dataMongodbatlasCloudBackupSchedulePolicyItemWeeklyToTerraform(struct?: DataMongodbatlasCloudBackupSchedulePolicyItemWeekly): any;
export declare class DataMongodbatlasCloudBackupSchedulePolicyItemWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupSchedulePolicyItemWeekly | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupSchedulePolicyItemWeekly | undefined);
    get frequencyInterval(): number;
    get frequencyType(): string;
    get id(): string;
    get retentionUnit(): string;
    get retentionValue(): number;
}
export declare class DataMongodbatlasCloudBackupSchedulePolicyItemWeeklyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupSchedulePolicyItemWeeklyOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_schedule mongodbatlas_cloud_backup_schedule}
*/
export declare class DataMongodbatlasCloudBackupSchedule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_cloud_backup_schedule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_schedule mongodbatlas_cloud_backup_schedule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasCloudBackupScheduleConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasCloudBackupScheduleConfig);
    get autoExportEnabled(): cdktf.IResolvable;
    get clusterId(): string;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _copySettings;
    get copySettings(): DataMongodbatlasCloudBackupScheduleCopySettingsList;
    private _export;
    get export(): DataMongodbatlasCloudBackupScheduleExportList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idPolicy(): string;
    get nextSnapshot(): string;
    private _policyItemDaily;
    get policyItemDaily(): DataMongodbatlasCloudBackupSchedulePolicyItemDailyList;
    private _policyItemHourly;
    get policyItemHourly(): DataMongodbatlasCloudBackupSchedulePolicyItemHourlyList;
    private _policyItemMonthly;
    get policyItemMonthly(): DataMongodbatlasCloudBackupSchedulePolicyItemMonthlyList;
    private _policyItemWeekly;
    get policyItemWeekly(): DataMongodbatlasCloudBackupSchedulePolicyItemWeeklyList;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get referenceHourOfDay(): number;
    get referenceMinuteOfHour(): number;
    get restoreWindowDays(): number;
    get useOrgAndGroupNamesInExportPrefix(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
