import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasCloudBackupSnapshotExportBucketsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_buckets#id DataMongodbatlasCloudBackupSnapshotExportBuckets#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_buckets#items_per_page DataMongodbatlasCloudBackupSnapshotExportBuckets#items_per_page}
    */
    readonly itemsPerPage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_buckets#page_num DataMongodbatlasCloudBackupSnapshotExportBuckets#page_num}
    */
    readonly pageNum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_buckets#project_id DataMongodbatlasCloudBackupSnapshotExportBuckets#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasCloudBackupSnapshotExportBucketsResults {
}
export declare function dataMongodbatlasCloudBackupSnapshotExportBucketsResultsToTerraform(struct?: DataMongodbatlasCloudBackupSnapshotExportBucketsResults): any;
export declare class DataMongodbatlasCloudBackupSnapshotExportBucketsResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupSnapshotExportBucketsResults | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupSnapshotExportBucketsResults | undefined);
    get bucketName(): string;
    get cloudProvider(): string;
    get exportBucketId(): string;
    get iamRoleId(): string;
}
export declare class DataMongodbatlasCloudBackupSnapshotExportBucketsResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupSnapshotExportBucketsResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_buckets mongodbatlas_cloud_backup_snapshot_export_buckets}
*/
export declare class DataMongodbatlasCloudBackupSnapshotExportBuckets extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_cloud_backup_snapshot_export_buckets";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_buckets mongodbatlas_cloud_backup_snapshot_export_buckets} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasCloudBackupSnapshotExportBucketsConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasCloudBackupSnapshotExportBucketsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _itemsPerPage?;
    get itemsPerPage(): number;
    set itemsPerPage(value: number);
    resetItemsPerPage(): void;
    get itemsPerPageInput(): number | undefined;
    private _pageNum?;
    get pageNum(): number;
    set pageNum(value: number);
    resetPageNum(): void;
    get pageNumInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasCloudBackupSnapshotExportBucketsResultsList;
    get totalCount(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
