import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasCloudBackupSnapshotExportJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_job#cluster_name DataMongodbatlasCloudBackupSnapshotExportJob#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_job#export_job_id DataMongodbatlasCloudBackupSnapshotExportJob#export_job_id}
    */
    readonly exportJobId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_job#id DataMongodbatlasCloudBackupSnapshotExportJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_job#project_id DataMongodbatlasCloudBackupSnapshotExportJob#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasCloudBackupSnapshotExportJobComponents {
}
export declare function dataMongodbatlasCloudBackupSnapshotExportJobComponentsToTerraform(struct?: DataMongodbatlasCloudBackupSnapshotExportJobComponents): any;
export declare class DataMongodbatlasCloudBackupSnapshotExportJobComponentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupSnapshotExportJobComponents | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupSnapshotExportJobComponents | undefined);
    get exportId(): string;
    get replicaSetName(): string;
}
export declare class DataMongodbatlasCloudBackupSnapshotExportJobComponentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupSnapshotExportJobComponentsOutputReference;
}
export interface DataMongodbatlasCloudBackupSnapshotExportJobCustomData {
}
export declare function dataMongodbatlasCloudBackupSnapshotExportJobCustomDataToTerraform(struct?: DataMongodbatlasCloudBackupSnapshotExportJobCustomData): any;
export declare class DataMongodbatlasCloudBackupSnapshotExportJobCustomDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupSnapshotExportJobCustomData | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupSnapshotExportJobCustomData | undefined);
    get key(): string;
    get value(): string;
}
export declare class DataMongodbatlasCloudBackupSnapshotExportJobCustomDataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupSnapshotExportJobCustomDataOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_job mongodbatlas_cloud_backup_snapshot_export_job}
*/
export declare class DataMongodbatlasCloudBackupSnapshotExportJob extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_cloud_backup_snapshot_export_job";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_job mongodbatlas_cloud_backup_snapshot_export_job} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasCloudBackupSnapshotExportJobConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasCloudBackupSnapshotExportJobConfig);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _components;
    get components(): DataMongodbatlasCloudBackupSnapshotExportJobComponentsList;
    get createdAt(): string;
    private _customData;
    get customData(): DataMongodbatlasCloudBackupSnapshotExportJobCustomDataList;
    get errMsg(): string;
    get exportBucketId(): string;
    private _exportJobId?;
    get exportJobId(): string;
    set exportJobId(value: string);
    get exportJobIdInput(): string | undefined;
    get exportStatusExportedCollections(): number;
    get exportStatusTotalCollections(): number;
    get finishedAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get prefix(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get snapshotId(): string;
    get state(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
