import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasCloudBackupSnapshotExportJobsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_jobs#cluster_name DataMongodbatlasCloudBackupSnapshotExportJobs#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_jobs#id DataMongodbatlasCloudBackupSnapshotExportJobs#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_jobs#items_per_page DataMongodbatlasCloudBackupSnapshotExportJobs#items_per_page}
    */
    readonly itemsPerPage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_jobs#page_num DataMongodbatlasCloudBackupSnapshotExportJobs#page_num}
    */
    readonly pageNum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_jobs#project_id DataMongodbatlasCloudBackupSnapshotExportJobs#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasCloudBackupSnapshotExportJobsResultsComponents {
}
export declare function dataMongodbatlasCloudBackupSnapshotExportJobsResultsComponentsToTerraform(struct?: DataMongodbatlasCloudBackupSnapshotExportJobsResultsComponents): any;
export declare class DataMongodbatlasCloudBackupSnapshotExportJobsResultsComponentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupSnapshotExportJobsResultsComponents | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupSnapshotExportJobsResultsComponents | undefined);
    get exportId(): string;
    get replicaSetName(): string;
}
export declare class DataMongodbatlasCloudBackupSnapshotExportJobsResultsComponentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupSnapshotExportJobsResultsComponentsOutputReference;
}
export interface DataMongodbatlasCloudBackupSnapshotExportJobsResultsCustomData {
}
export declare function dataMongodbatlasCloudBackupSnapshotExportJobsResultsCustomDataToTerraform(struct?: DataMongodbatlasCloudBackupSnapshotExportJobsResultsCustomData): any;
export declare class DataMongodbatlasCloudBackupSnapshotExportJobsResultsCustomDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupSnapshotExportJobsResultsCustomData | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupSnapshotExportJobsResultsCustomData | undefined);
    get key(): string;
    get value(): string;
}
export declare class DataMongodbatlasCloudBackupSnapshotExportJobsResultsCustomDataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupSnapshotExportJobsResultsCustomDataOutputReference;
}
export interface DataMongodbatlasCloudBackupSnapshotExportJobsResults {
}
export declare function dataMongodbatlasCloudBackupSnapshotExportJobsResultsToTerraform(struct?: DataMongodbatlasCloudBackupSnapshotExportJobsResults): any;
export declare class DataMongodbatlasCloudBackupSnapshotExportJobsResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupSnapshotExportJobsResults | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupSnapshotExportJobsResults | undefined);
    private _components;
    get components(): DataMongodbatlasCloudBackupSnapshotExportJobsResultsComponentsList;
    get createdAt(): string;
    private _customData;
    get customData(): DataMongodbatlasCloudBackupSnapshotExportJobsResultsCustomDataList;
    get errMsg(): string;
    get exportBucketId(): string;
    get exportJobId(): string;
    get exportStatusExportedCollections(): number;
    get exportStatusTotalCollections(): number;
    get finishedAt(): string;
    get prefix(): string;
    get snapshotId(): string;
    get state(): string;
}
export declare class DataMongodbatlasCloudBackupSnapshotExportJobsResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupSnapshotExportJobsResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_jobs mongodbatlas_cloud_backup_snapshot_export_jobs}
*/
export declare class DataMongodbatlasCloudBackupSnapshotExportJobs extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_cloud_backup_snapshot_export_jobs";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_export_jobs mongodbatlas_cloud_backup_snapshot_export_jobs} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasCloudBackupSnapshotExportJobsConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasCloudBackupSnapshotExportJobsConfig);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _itemsPerPage?;
    get itemsPerPage(): number;
    set itemsPerPage(value: number);
    resetItemsPerPage(): void;
    get itemsPerPageInput(): number | undefined;
    private _pageNum?;
    get pageNum(): number;
    set pageNum(value: number);
    resetPageNum(): void;
    get pageNumInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasCloudBackupSnapshotExportJobsResultsList;
    get totalCount(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
