import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasCloudBackupSnapshotRestoreJobsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_restore_jobs#cluster_name DataMongodbatlasCloudBackupSnapshotRestoreJobs#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_restore_jobs#id DataMongodbatlasCloudBackupSnapshotRestoreJobs#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_restore_jobs#items_per_page DataMongodbatlasCloudBackupSnapshotRestoreJobs#items_per_page}
    */
    readonly itemsPerPage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_restore_jobs#page_num DataMongodbatlasCloudBackupSnapshotRestoreJobs#page_num}
    */
    readonly pageNum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_restore_jobs#project_id DataMongodbatlasCloudBackupSnapshotRestoreJobs#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasCloudBackupSnapshotRestoreJobsResults {
}
export declare function dataMongodbatlasCloudBackupSnapshotRestoreJobsResultsToTerraform(struct?: DataMongodbatlasCloudBackupSnapshotRestoreJobsResults): any;
export declare class DataMongodbatlasCloudBackupSnapshotRestoreJobsResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudBackupSnapshotRestoreJobsResults | undefined;
    set internalValue(value: DataMongodbatlasCloudBackupSnapshotRestoreJobsResults | undefined);
    get cancelled(): cdktf.IResolvable;
    get createdAt(): string;
    get deliveryType(): string;
    get deliveryUrl(): string[];
    get expired(): cdktf.IResolvable;
    get expiresAt(): string;
    get finishedAt(): string;
    get id(): string;
    get oplogInc(): number;
    get oplogTs(): number;
    get pointInTimeUtcSeconds(): number;
    get snapshotId(): string;
    get targetClusterName(): string;
    get targetProjectId(): string;
    get timestamp(): string;
}
export declare class DataMongodbatlasCloudBackupSnapshotRestoreJobsResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudBackupSnapshotRestoreJobsResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_restore_jobs mongodbatlas_cloud_backup_snapshot_restore_jobs}
*/
export declare class DataMongodbatlasCloudBackupSnapshotRestoreJobs extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_cloud_backup_snapshot_restore_jobs";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_backup_snapshot_restore_jobs mongodbatlas_cloud_backup_snapshot_restore_jobs} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasCloudBackupSnapshotRestoreJobsConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasCloudBackupSnapshotRestoreJobsConfig);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _itemsPerPage?;
    get itemsPerPage(): number;
    set itemsPerPage(value: number);
    resetItemsPerPage(): void;
    get itemsPerPageInput(): number | undefined;
    private _pageNum?;
    get pageNum(): number;
    set pageNum(value: number);
    resetPageNum(): void;
    get pageNumInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasCloudBackupSnapshotRestoreJobsResultsList;
    get totalCount(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
