import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasCloudProviderAccessSetupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_access_setup#id DataMongodbatlasCloudProviderAccessSetup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_access_setup#project_id DataMongodbatlasCloudProviderAccessSetup#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_access_setup#provider_name DataMongodbatlasCloudProviderAccessSetup#provider_name}
    */
    readonly providerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_access_setup#role_id DataMongodbatlasCloudProviderAccessSetup#role_id}
    */
    readonly roleId: string;
}
export interface DataMongodbatlasCloudProviderAccessSetupAwsConfig {
}
export declare function dataMongodbatlasCloudProviderAccessSetupAwsConfigToTerraform(struct?: DataMongodbatlasCloudProviderAccessSetupAwsConfig): any;
export declare class DataMongodbatlasCloudProviderAccessSetupAwsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudProviderAccessSetupAwsConfig | undefined;
    set internalValue(value: DataMongodbatlasCloudProviderAccessSetupAwsConfig | undefined);
    get atlasAssumedRoleExternalId(): string;
    get atlasAwsAccountArn(): string;
}
export declare class DataMongodbatlasCloudProviderAccessSetupAwsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudProviderAccessSetupAwsConfigOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_access_setup mongodbatlas_cloud_provider_access_setup}
*/
export declare class DataMongodbatlasCloudProviderAccessSetup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_cloud_provider_access_setup";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_access_setup mongodbatlas_cloud_provider_access_setup} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasCloudProviderAccessSetupConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasCloudProviderAccessSetupConfig);
    private _aws;
    get aws(): cdktf.StringMap;
    private _awsConfig;
    get awsConfig(): DataMongodbatlasCloudProviderAccessSetupAwsConfigList;
    get createdDate(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    get roleIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
