import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasCloudProviderAccessConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_access#id DataMongodbatlasCloudProviderAccess#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_access#project_id DataMongodbatlasCloudProviderAccess#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasCloudProviderAccessAwsIamRolesFeatureUsages {
}
export declare function dataMongodbatlasCloudProviderAccessAwsIamRolesFeatureUsagesToTerraform(struct?: DataMongodbatlasCloudProviderAccessAwsIamRolesFeatureUsages): any;
export declare class DataMongodbatlasCloudProviderAccessAwsIamRolesFeatureUsagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudProviderAccessAwsIamRolesFeatureUsages | undefined;
    set internalValue(value: DataMongodbatlasCloudProviderAccessAwsIamRolesFeatureUsages | undefined);
    private _featureId;
    get featureId(): cdktf.StringMap;
    get featureType(): string;
}
export declare class DataMongodbatlasCloudProviderAccessAwsIamRolesFeatureUsagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudProviderAccessAwsIamRolesFeatureUsagesOutputReference;
}
export interface DataMongodbatlasCloudProviderAccessAwsIamRoles {
}
export declare function dataMongodbatlasCloudProviderAccessAwsIamRolesToTerraform(struct?: DataMongodbatlasCloudProviderAccessAwsIamRoles): any;
export declare class DataMongodbatlasCloudProviderAccessAwsIamRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCloudProviderAccessAwsIamRoles | undefined;
    set internalValue(value: DataMongodbatlasCloudProviderAccessAwsIamRoles | undefined);
    get atlasAssumedRoleExternalId(): string;
    get atlasAwsAccountArn(): string;
    get authorizedDate(): string;
    get createdDate(): string;
    private _featureUsages;
    get featureUsages(): DataMongodbatlasCloudProviderAccessAwsIamRolesFeatureUsagesList;
    get iamAssumedRoleArn(): string;
    get providerName(): string;
    get roleId(): string;
}
export declare class DataMongodbatlasCloudProviderAccessAwsIamRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCloudProviderAccessAwsIamRolesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_access mongodbatlas_cloud_provider_access}
*/
export declare class DataMongodbatlasCloudProviderAccess extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_cloud_provider_access";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_access mongodbatlas_cloud_provider_access} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasCloudProviderAccessConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasCloudProviderAccessConfig);
    private _awsIamRoles;
    get awsIamRoles(): DataMongodbatlasCloudProviderAccessAwsIamRolesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
