import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasCloudProviderSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_snapshot#cluster_name DataMongodbatlasCloudProviderSnapshot#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_snapshot#id DataMongodbatlasCloudProviderSnapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_snapshot#project_id DataMongodbatlasCloudProviderSnapshot#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_snapshot#snapshot_id DataMongodbatlasCloudProviderSnapshot#snapshot_id}
    */
    readonly snapshotId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_snapshot mongodbatlas_cloud_provider_snapshot}
*/
export declare class DataMongodbatlasCloudProviderSnapshot extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_cloud_provider_snapshot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cloud_provider_snapshot mongodbatlas_cloud_provider_snapshot} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasCloudProviderSnapshotConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasCloudProviderSnapshotConfig);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    get createdAt(): string;
    get description(): string;
    get expiresAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get masterKeyUuid(): string;
    get mongodVersion(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    get snapshotIdInput(): string | undefined;
    get snapshotType(): string;
    get status(): string;
    get storageSizeBytes(): number;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
