import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cluster#id DataMongodbatlasCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cluster#name DataMongodbatlasCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cluster#project_id DataMongodbatlasCluster#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasClusterAdvancedConfiguration {
}
export declare function dataMongodbatlasClusterAdvancedConfigurationToTerraform(struct?: DataMongodbatlasClusterAdvancedConfiguration): any;
export declare class DataMongodbatlasClusterAdvancedConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClusterAdvancedConfiguration | undefined;
    set internalValue(value: DataMongodbatlasClusterAdvancedConfiguration | undefined);
    get defaultReadConcern(): string;
    get defaultWriteConcern(): string;
    get failIndexKeyTooLong(): cdktf.IResolvable;
    get javascriptEnabled(): cdktf.IResolvable;
    get minimumEnabledTlsProtocol(): string;
    get noTableScan(): cdktf.IResolvable;
    get oplogMinRetentionHours(): number;
    get oplogSizeMb(): number;
    get sampleRefreshIntervalBiConnector(): number;
    get sampleSizeBiConnector(): number;
}
export declare class DataMongodbatlasClusterAdvancedConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClusterAdvancedConfigurationOutputReference;
}
export interface DataMongodbatlasClusterBiConnectorConfig {
}
export declare function dataMongodbatlasClusterBiConnectorConfigToTerraform(struct?: DataMongodbatlasClusterBiConnectorConfig): any;
export declare class DataMongodbatlasClusterBiConnectorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClusterBiConnectorConfig | undefined;
    set internalValue(value: DataMongodbatlasClusterBiConnectorConfig | undefined);
    get enabled(): cdktf.IResolvable;
    get readPreference(): string;
}
export declare class DataMongodbatlasClusterBiConnectorConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClusterBiConnectorConfigOutputReference;
}
export interface DataMongodbatlasClusterConnectionStringsPrivateEndpointEndpoints {
}
export declare function dataMongodbatlasClusterConnectionStringsPrivateEndpointEndpointsToTerraform(struct?: DataMongodbatlasClusterConnectionStringsPrivateEndpointEndpoints): any;
export declare class DataMongodbatlasClusterConnectionStringsPrivateEndpointEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClusterConnectionStringsPrivateEndpointEndpoints | undefined;
    set internalValue(value: DataMongodbatlasClusterConnectionStringsPrivateEndpointEndpoints | undefined);
    get endpointId(): string;
    get providerName(): string;
    get region(): string;
}
export declare class DataMongodbatlasClusterConnectionStringsPrivateEndpointEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClusterConnectionStringsPrivateEndpointEndpointsOutputReference;
}
export interface DataMongodbatlasClusterConnectionStringsPrivateEndpoint {
}
export declare function dataMongodbatlasClusterConnectionStringsPrivateEndpointToTerraform(struct?: DataMongodbatlasClusterConnectionStringsPrivateEndpoint): any;
export declare class DataMongodbatlasClusterConnectionStringsPrivateEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClusterConnectionStringsPrivateEndpoint | undefined;
    set internalValue(value: DataMongodbatlasClusterConnectionStringsPrivateEndpoint | undefined);
    get connectionString(): string;
    private _endpoints;
    get endpoints(): DataMongodbatlasClusterConnectionStringsPrivateEndpointEndpointsList;
    get srvConnectionString(): string;
    get type(): string;
}
export declare class DataMongodbatlasClusterConnectionStringsPrivateEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClusterConnectionStringsPrivateEndpointOutputReference;
}
export interface DataMongodbatlasClusterConnectionStrings {
}
export declare function dataMongodbatlasClusterConnectionStringsToTerraform(struct?: DataMongodbatlasClusterConnectionStrings): any;
export declare class DataMongodbatlasClusterConnectionStringsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClusterConnectionStrings | undefined;
    set internalValue(value: DataMongodbatlasClusterConnectionStrings | undefined);
    private _awsPrivateLink;
    get awsPrivateLink(): cdktf.StringMap;
    private _awsPrivateLinkSrv;
    get awsPrivateLinkSrv(): cdktf.StringMap;
    get private(): string;
    private _privateEndpoint;
    get privateEndpoint(): DataMongodbatlasClusterConnectionStringsPrivateEndpointList;
    get privateSrv(): string;
    get standard(): string;
    get standardSrv(): string;
}
export declare class DataMongodbatlasClusterConnectionStringsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClusterConnectionStringsOutputReference;
}
export interface DataMongodbatlasClusterLabels {
}
export declare function dataMongodbatlasClusterLabelsToTerraform(struct?: DataMongodbatlasClusterLabels): any;
export declare class DataMongodbatlasClusterLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClusterLabels | undefined;
    set internalValue(value: DataMongodbatlasClusterLabels | undefined);
    get key(): string;
    get value(): string;
}
export declare class DataMongodbatlasClusterLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClusterLabelsOutputReference;
}
export interface DataMongodbatlasClusterReplicationSpecsRegionsConfig {
}
export declare function dataMongodbatlasClusterReplicationSpecsRegionsConfigToTerraform(struct?: DataMongodbatlasClusterReplicationSpecsRegionsConfig): any;
export declare class DataMongodbatlasClusterReplicationSpecsRegionsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClusterReplicationSpecsRegionsConfig | undefined;
    set internalValue(value: DataMongodbatlasClusterReplicationSpecsRegionsConfig | undefined);
    get analyticsNodes(): number;
    get electableNodes(): number;
    get priority(): number;
    get readOnlyNodes(): number;
    get regionName(): string;
}
export declare class DataMongodbatlasClusterReplicationSpecsRegionsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClusterReplicationSpecsRegionsConfigOutputReference;
}
export interface DataMongodbatlasClusterReplicationSpecs {
}
export declare function dataMongodbatlasClusterReplicationSpecsToTerraform(struct?: DataMongodbatlasClusterReplicationSpecs): any;
export declare class DataMongodbatlasClusterReplicationSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClusterReplicationSpecs | undefined;
    set internalValue(value: DataMongodbatlasClusterReplicationSpecs | undefined);
    get id(): string;
    get numShards(): number;
    private _regionsConfig;
    get regionsConfig(): DataMongodbatlasClusterReplicationSpecsRegionsConfigList;
    get zoneName(): string;
}
export declare class DataMongodbatlasClusterReplicationSpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClusterReplicationSpecsOutputReference;
}
export interface DataMongodbatlasClusterSnapshotBackupPolicyPoliciesPolicyItem {
}
export declare function dataMongodbatlasClusterSnapshotBackupPolicyPoliciesPolicyItemToTerraform(struct?: DataMongodbatlasClusterSnapshotBackupPolicyPoliciesPolicyItem): any;
export declare class DataMongodbatlasClusterSnapshotBackupPolicyPoliciesPolicyItemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClusterSnapshotBackupPolicyPoliciesPolicyItem | undefined;
    set internalValue(value: DataMongodbatlasClusterSnapshotBackupPolicyPoliciesPolicyItem | undefined);
    get frequencyInterval(): number;
    get frequencyType(): string;
    get id(): string;
    get retentionUnit(): string;
    get retentionValue(): number;
}
export declare class DataMongodbatlasClusterSnapshotBackupPolicyPoliciesPolicyItemList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClusterSnapshotBackupPolicyPoliciesPolicyItemOutputReference;
}
export interface DataMongodbatlasClusterSnapshotBackupPolicyPolicies {
}
export declare function dataMongodbatlasClusterSnapshotBackupPolicyPoliciesToTerraform(struct?: DataMongodbatlasClusterSnapshotBackupPolicyPolicies): any;
export declare class DataMongodbatlasClusterSnapshotBackupPolicyPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClusterSnapshotBackupPolicyPolicies | undefined;
    set internalValue(value: DataMongodbatlasClusterSnapshotBackupPolicyPolicies | undefined);
    get id(): string;
    private _policyItem;
    get policyItem(): DataMongodbatlasClusterSnapshotBackupPolicyPoliciesPolicyItemList;
}
export declare class DataMongodbatlasClusterSnapshotBackupPolicyPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClusterSnapshotBackupPolicyPoliciesOutputReference;
}
export interface DataMongodbatlasClusterSnapshotBackupPolicy {
}
export declare function dataMongodbatlasClusterSnapshotBackupPolicyToTerraform(struct?: DataMongodbatlasClusterSnapshotBackupPolicy): any;
export declare class DataMongodbatlasClusterSnapshotBackupPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClusterSnapshotBackupPolicy | undefined;
    set internalValue(value: DataMongodbatlasClusterSnapshotBackupPolicy | undefined);
    get clusterId(): string;
    get clusterName(): string;
    get nextSnapshot(): string;
    private _policies;
    get policies(): DataMongodbatlasClusterSnapshotBackupPolicyPoliciesList;
    get referenceHourOfDay(): number;
    get referenceMinuteOfHour(): number;
    get restoreWindowDays(): number;
    get updateSnapshots(): cdktf.IResolvable;
}
export declare class DataMongodbatlasClusterSnapshotBackupPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClusterSnapshotBackupPolicyOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cluster mongodbatlas_cluster}
*/
export declare class DataMongodbatlasCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/cluster mongodbatlas_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasClusterConfig);
    private _advancedConfiguration;
    get advancedConfiguration(): DataMongodbatlasClusterAdvancedConfigurationList;
    get autoScalingComputeEnabled(): cdktf.IResolvable;
    get autoScalingComputeScaleDownEnabled(): cdktf.IResolvable;
    get autoScalingDiskGbEnabled(): cdktf.IResolvable;
    get backingProviderName(): string;
    get backupEnabled(): cdktf.IResolvable;
    private _biConnector;
    get biConnector(): cdktf.StringMap;
    private _biConnectorConfig;
    get biConnectorConfig(): DataMongodbatlasClusterBiConnectorConfigList;
    get clusterType(): string;
    private _connectionStrings;
    get connectionStrings(): DataMongodbatlasClusterConnectionStringsList;
    get containerId(): string;
    get diskSizeGb(): number;
    get encryptionAtRestProvider(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): DataMongodbatlasClusterLabelsList;
    get mongoDbMajorVersion(): string;
    get mongoDbVersion(): string;
    get mongoUri(): string;
    get mongoUriUpdated(): string;
    get mongoUriWithOptions(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get numShards(): number;
    get paused(): cdktf.IResolvable;
    get pitEnabled(): cdktf.IResolvable;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get providerAutoScalingComputeMaxInstanceSize(): string;
    get providerAutoScalingComputeMinInstanceSize(): string;
    get providerBackupEnabled(): cdktf.IResolvable;
    get providerDiskIops(): number;
    get providerDiskTypeName(): string;
    get providerEncryptEbsVolume(): cdktf.IResolvable;
    get providerEncryptEbsVolumeFlag(): cdktf.IResolvable;
    get providerInstanceSizeName(): string;
    get providerName(): string;
    get providerRegionName(): string;
    get providerVolumeType(): string;
    get replicationFactor(): number;
    private _replicationSpecs;
    get replicationSpecs(): DataMongodbatlasClusterReplicationSpecsList;
    private _snapshotBackupPolicy;
    get snapshotBackupPolicy(): DataMongodbatlasClusterSnapshotBackupPolicyList;
    get srvAddress(): string;
    get stateName(): string;
    get terminationProtectionEnabled(): cdktf.IResolvable;
    get versionReleaseSystem(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
