import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasClustersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/clusters#id DataMongodbatlasClusters#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/clusters#project_id DataMongodbatlasClusters#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasClustersResultsAdvancedConfiguration {
}
export declare function dataMongodbatlasClustersResultsAdvancedConfigurationToTerraform(struct?: DataMongodbatlasClustersResultsAdvancedConfiguration): any;
export declare class DataMongodbatlasClustersResultsAdvancedConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResultsAdvancedConfiguration | undefined;
    set internalValue(value: DataMongodbatlasClustersResultsAdvancedConfiguration | undefined);
    get defaultReadConcern(): string;
    get defaultWriteConcern(): string;
    get failIndexKeyTooLong(): cdktf.IResolvable;
    get javascriptEnabled(): cdktf.IResolvable;
    get minimumEnabledTlsProtocol(): string;
    get noTableScan(): cdktf.IResolvable;
    get oplogMinRetentionHours(): number;
    get oplogSizeMb(): number;
    get sampleRefreshIntervalBiConnector(): number;
    get sampleSizeBiConnector(): number;
}
export declare class DataMongodbatlasClustersResultsAdvancedConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsAdvancedConfigurationOutputReference;
}
export interface DataMongodbatlasClustersResultsBiConnectorConfig {
}
export declare function dataMongodbatlasClustersResultsBiConnectorConfigToTerraform(struct?: DataMongodbatlasClustersResultsBiConnectorConfig): any;
export declare class DataMongodbatlasClustersResultsBiConnectorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResultsBiConnectorConfig | undefined;
    set internalValue(value: DataMongodbatlasClustersResultsBiConnectorConfig | undefined);
    get enabled(): cdktf.IResolvable;
    get readPreference(): string;
}
export declare class DataMongodbatlasClustersResultsBiConnectorConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsBiConnectorConfigOutputReference;
}
export interface DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointEndpoints {
}
export declare function dataMongodbatlasClustersResultsConnectionStringsPrivateEndpointEndpointsToTerraform(struct?: DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointEndpoints): any;
export declare class DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointEndpoints | undefined;
    set internalValue(value: DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointEndpoints | undefined);
    get endpointId(): string;
    get providerName(): string;
    get region(): string;
}
export declare class DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointEndpointsOutputReference;
}
export interface DataMongodbatlasClustersResultsConnectionStringsPrivateEndpoint {
}
export declare function dataMongodbatlasClustersResultsConnectionStringsPrivateEndpointToTerraform(struct?: DataMongodbatlasClustersResultsConnectionStringsPrivateEndpoint): any;
export declare class DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResultsConnectionStringsPrivateEndpoint | undefined;
    set internalValue(value: DataMongodbatlasClustersResultsConnectionStringsPrivateEndpoint | undefined);
    get connectionString(): string;
    private _endpoints;
    get endpoints(): DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointEndpointsList;
    get srvConnectionString(): string;
    get type(): string;
}
export declare class DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointOutputReference;
}
export interface DataMongodbatlasClustersResultsConnectionStrings {
}
export declare function dataMongodbatlasClustersResultsConnectionStringsToTerraform(struct?: DataMongodbatlasClustersResultsConnectionStrings): any;
export declare class DataMongodbatlasClustersResultsConnectionStringsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResultsConnectionStrings | undefined;
    set internalValue(value: DataMongodbatlasClustersResultsConnectionStrings | undefined);
    private _awsPrivateLink;
    get awsPrivateLink(): cdktf.StringMap;
    private _awsPrivateLinkSrv;
    get awsPrivateLinkSrv(): cdktf.StringMap;
    get private(): string;
    private _privateEndpoint;
    get privateEndpoint(): DataMongodbatlasClustersResultsConnectionStringsPrivateEndpointList;
    get privateSrv(): string;
    get standard(): string;
    get standardSrv(): string;
}
export declare class DataMongodbatlasClustersResultsConnectionStringsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsConnectionStringsOutputReference;
}
export interface DataMongodbatlasClustersResultsLabels {
}
export declare function dataMongodbatlasClustersResultsLabelsToTerraform(struct?: DataMongodbatlasClustersResultsLabels): any;
export declare class DataMongodbatlasClustersResultsLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResultsLabels | undefined;
    set internalValue(value: DataMongodbatlasClustersResultsLabels | undefined);
    get key(): string;
    get value(): string;
}
export declare class DataMongodbatlasClustersResultsLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsLabelsOutputReference;
}
export interface DataMongodbatlasClustersResultsReplicationSpecsRegionsConfig {
}
export declare function dataMongodbatlasClustersResultsReplicationSpecsRegionsConfigToTerraform(struct?: DataMongodbatlasClustersResultsReplicationSpecsRegionsConfig): any;
export declare class DataMongodbatlasClustersResultsReplicationSpecsRegionsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResultsReplicationSpecsRegionsConfig | undefined;
    set internalValue(value: DataMongodbatlasClustersResultsReplicationSpecsRegionsConfig | undefined);
    get analyticsNodes(): number;
    get electableNodes(): number;
    get priority(): number;
    get readOnlyNodes(): number;
    get regionName(): string;
}
export declare class DataMongodbatlasClustersResultsReplicationSpecsRegionsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsReplicationSpecsRegionsConfigOutputReference;
}
export interface DataMongodbatlasClustersResultsReplicationSpecs {
}
export declare function dataMongodbatlasClustersResultsReplicationSpecsToTerraform(struct?: DataMongodbatlasClustersResultsReplicationSpecs): any;
export declare class DataMongodbatlasClustersResultsReplicationSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResultsReplicationSpecs | undefined;
    set internalValue(value: DataMongodbatlasClustersResultsReplicationSpecs | undefined);
    get id(): string;
    get numShards(): number;
    private _regionsConfig;
    get regionsConfig(): DataMongodbatlasClustersResultsReplicationSpecsRegionsConfigList;
    get zoneName(): string;
}
export declare class DataMongodbatlasClustersResultsReplicationSpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsReplicationSpecsOutputReference;
}
export interface DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesPolicyItem {
}
export declare function dataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesPolicyItemToTerraform(struct?: DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesPolicyItem): any;
export declare class DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesPolicyItemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesPolicyItem | undefined;
    set internalValue(value: DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesPolicyItem | undefined);
    get frequencyInterval(): number;
    get frequencyType(): string;
    get id(): string;
    get retentionUnit(): string;
    get retentionValue(): number;
}
export declare class DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesPolicyItemList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesPolicyItemOutputReference;
}
export interface DataMongodbatlasClustersResultsSnapshotBackupPolicyPolicies {
}
export declare function dataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesToTerraform(struct?: DataMongodbatlasClustersResultsSnapshotBackupPolicyPolicies): any;
export declare class DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResultsSnapshotBackupPolicyPolicies | undefined;
    set internalValue(value: DataMongodbatlasClustersResultsSnapshotBackupPolicyPolicies | undefined);
    get id(): string;
    private _policyItem;
    get policyItem(): DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesPolicyItemList;
}
export declare class DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesOutputReference;
}
export interface DataMongodbatlasClustersResultsSnapshotBackupPolicy {
}
export declare function dataMongodbatlasClustersResultsSnapshotBackupPolicyToTerraform(struct?: DataMongodbatlasClustersResultsSnapshotBackupPolicy): any;
export declare class DataMongodbatlasClustersResultsSnapshotBackupPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResultsSnapshotBackupPolicy | undefined;
    set internalValue(value: DataMongodbatlasClustersResultsSnapshotBackupPolicy | undefined);
    get clusterId(): string;
    get clusterName(): string;
    get nextSnapshot(): string;
    private _policies;
    get policies(): DataMongodbatlasClustersResultsSnapshotBackupPolicyPoliciesList;
    get referenceHourOfDay(): number;
    get referenceMinuteOfHour(): number;
    get restoreWindowDays(): number;
    get updateSnapshots(): cdktf.IResolvable;
}
export declare class DataMongodbatlasClustersResultsSnapshotBackupPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsSnapshotBackupPolicyOutputReference;
}
export interface DataMongodbatlasClustersResults {
}
export declare function dataMongodbatlasClustersResultsToTerraform(struct?: DataMongodbatlasClustersResults): any;
export declare class DataMongodbatlasClustersResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasClustersResults | undefined;
    set internalValue(value: DataMongodbatlasClustersResults | undefined);
    private _advancedConfiguration;
    get advancedConfiguration(): DataMongodbatlasClustersResultsAdvancedConfigurationList;
    get autoScalingComputeEnabled(): cdktf.IResolvable;
    get autoScalingComputeScaleDownEnabled(): cdktf.IResolvable;
    get autoScalingDiskGbEnabled(): cdktf.IResolvable;
    get backingProviderName(): string;
    get backupEnabled(): cdktf.IResolvable;
    private _biConnector;
    get biConnector(): cdktf.StringMap;
    private _biConnectorConfig;
    get biConnectorConfig(): DataMongodbatlasClustersResultsBiConnectorConfigList;
    get clusterType(): string;
    private _connectionStrings;
    get connectionStrings(): DataMongodbatlasClustersResultsConnectionStringsList;
    get containerId(): string;
    get diskSizeGb(): number;
    get encryptionAtRestProvider(): string;
    private _labels;
    get labels(): DataMongodbatlasClustersResultsLabelsList;
    get mongoDbMajorVersion(): string;
    get mongoDbVersion(): string;
    get mongoUri(): string;
    get mongoUriUpdated(): string;
    get mongoUriWithOptions(): string;
    get name(): string;
    get numShards(): number;
    get paused(): cdktf.IResolvable;
    get pitEnabled(): cdktf.IResolvable;
    get providerAutoScalingComputeMaxInstanceSize(): string;
    get providerAutoScalingComputeMinInstanceSize(): string;
    get providerBackupEnabled(): cdktf.IResolvable;
    get providerDiskIops(): number;
    get providerDiskTypeName(): string;
    get providerEncryptEbsVolume(): cdktf.IResolvable;
    get providerInstanceSizeName(): string;
    get providerName(): string;
    get providerRegionName(): string;
    get providerVolumeType(): string;
    get replicationFactor(): number;
    private _replicationSpecs;
    get replicationSpecs(): DataMongodbatlasClustersResultsReplicationSpecsList;
    private _snapshotBackupPolicy;
    get snapshotBackupPolicy(): DataMongodbatlasClustersResultsSnapshotBackupPolicyList;
    get srvAddress(): string;
    get stateName(): string;
    get terminationProtectionEnabled(): cdktf.IResolvable;
    get versionReleaseSystem(): string;
}
export declare class DataMongodbatlasClustersResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasClustersResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/clusters mongodbatlas_clusters}
*/
export declare class DataMongodbatlasClusters extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_clusters";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/clusters mongodbatlas_clusters} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasClustersConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasClustersConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasClustersResultsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
