import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasCustomDbRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/custom_db_role#id DataMongodbatlasCustomDbRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/custom_db_role#project_id DataMongodbatlasCustomDbRole#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/custom_db_role#role_name DataMongodbatlasCustomDbRole#role_name}
    */
    readonly roleName: string;
    /**
    * inherited_roles block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/custom_db_role#inherited_roles DataMongodbatlasCustomDbRole#inherited_roles}
    */
    readonly inheritedRoles?: DataMongodbatlasCustomDbRoleInheritedRoles[] | cdktf.IResolvable;
}
export interface DataMongodbatlasCustomDbRoleActionsResources {
}
export declare function dataMongodbatlasCustomDbRoleActionsResourcesToTerraform(struct?: DataMongodbatlasCustomDbRoleActionsResources): any;
export declare class DataMongodbatlasCustomDbRoleActionsResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCustomDbRoleActionsResources | undefined;
    set internalValue(value: DataMongodbatlasCustomDbRoleActionsResources | undefined);
    get cluster(): cdktf.IResolvable;
    get collectionName(): string;
    get databaseName(): string;
}
export declare class DataMongodbatlasCustomDbRoleActionsResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCustomDbRoleActionsResourcesOutputReference;
}
export interface DataMongodbatlasCustomDbRoleActions {
}
export declare function dataMongodbatlasCustomDbRoleActionsToTerraform(struct?: DataMongodbatlasCustomDbRoleActions): any;
export declare class DataMongodbatlasCustomDbRoleActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCustomDbRoleActions | undefined;
    set internalValue(value: DataMongodbatlasCustomDbRoleActions | undefined);
    get action(): string;
    private _resources;
    get resources(): DataMongodbatlasCustomDbRoleActionsResourcesList;
}
export declare class DataMongodbatlasCustomDbRoleActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCustomDbRoleActionsOutputReference;
}
export interface DataMongodbatlasCustomDbRoleInheritedRoles {
}
export declare function dataMongodbatlasCustomDbRoleInheritedRolesToTerraform(struct?: DataMongodbatlasCustomDbRoleInheritedRoles | cdktf.IResolvable): any;
export declare class DataMongodbatlasCustomDbRoleInheritedRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCustomDbRoleInheritedRoles | cdktf.IResolvable | undefined;
    set internalValue(value: DataMongodbatlasCustomDbRoleInheritedRoles | cdktf.IResolvable | undefined);
    get databaseName(): string;
    get roleName(): string;
}
export declare class DataMongodbatlasCustomDbRoleInheritedRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataMongodbatlasCustomDbRoleInheritedRoles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCustomDbRoleInheritedRolesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/custom_db_role mongodbatlas_custom_db_role}
*/
export declare class DataMongodbatlasCustomDbRole extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_custom_db_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/custom_db_role mongodbatlas_custom_db_role} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasCustomDbRoleConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasCustomDbRoleConfig);
    private _actions;
    get actions(): DataMongodbatlasCustomDbRoleActionsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _inheritedRoles;
    get inheritedRoles(): DataMongodbatlasCustomDbRoleInheritedRolesList;
    putInheritedRoles(value: DataMongodbatlasCustomDbRoleInheritedRoles[] | cdktf.IResolvable): void;
    resetInheritedRoles(): void;
    get inheritedRolesInput(): cdktf.IResolvable | DataMongodbatlasCustomDbRoleInheritedRoles[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
