import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasCustomDbRolesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/custom_db_roles#id DataMongodbatlasCustomDbRoles#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/custom_db_roles#project_id DataMongodbatlasCustomDbRoles#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasCustomDbRolesResultsActionsResources {
}
export declare function dataMongodbatlasCustomDbRolesResultsActionsResourcesToTerraform(struct?: DataMongodbatlasCustomDbRolesResultsActionsResources): any;
export declare class DataMongodbatlasCustomDbRolesResultsActionsResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCustomDbRolesResultsActionsResources | undefined;
    set internalValue(value: DataMongodbatlasCustomDbRolesResultsActionsResources | undefined);
    get cluster(): cdktf.IResolvable;
    get collectionName(): string;
    get databaseName(): string;
}
export declare class DataMongodbatlasCustomDbRolesResultsActionsResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCustomDbRolesResultsActionsResourcesOutputReference;
}
export interface DataMongodbatlasCustomDbRolesResultsActions {
}
export declare function dataMongodbatlasCustomDbRolesResultsActionsToTerraform(struct?: DataMongodbatlasCustomDbRolesResultsActions): any;
export declare class DataMongodbatlasCustomDbRolesResultsActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCustomDbRolesResultsActions | undefined;
    set internalValue(value: DataMongodbatlasCustomDbRolesResultsActions | undefined);
    get action(): string;
    private _resources;
    get resources(): DataMongodbatlasCustomDbRolesResultsActionsResourcesList;
}
export declare class DataMongodbatlasCustomDbRolesResultsActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCustomDbRolesResultsActionsOutputReference;
}
export interface DataMongodbatlasCustomDbRolesResultsInheritedRoles {
}
export declare function dataMongodbatlasCustomDbRolesResultsInheritedRolesToTerraform(struct?: DataMongodbatlasCustomDbRolesResultsInheritedRoles): any;
export declare class DataMongodbatlasCustomDbRolesResultsInheritedRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCustomDbRolesResultsInheritedRoles | undefined;
    set internalValue(value: DataMongodbatlasCustomDbRolesResultsInheritedRoles | undefined);
    get databaseName(): string;
    get roleName(): string;
}
export declare class DataMongodbatlasCustomDbRolesResultsInheritedRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCustomDbRolesResultsInheritedRolesOutputReference;
}
export interface DataMongodbatlasCustomDbRolesResults {
}
export declare function dataMongodbatlasCustomDbRolesResultsToTerraform(struct?: DataMongodbatlasCustomDbRolesResults): any;
export declare class DataMongodbatlasCustomDbRolesResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasCustomDbRolesResults | undefined;
    set internalValue(value: DataMongodbatlasCustomDbRolesResults | undefined);
    private _actions;
    get actions(): DataMongodbatlasCustomDbRolesResultsActionsList;
    private _inheritedRoles;
    get inheritedRoles(): DataMongodbatlasCustomDbRolesResultsInheritedRolesList;
    get roleName(): string;
}
export declare class DataMongodbatlasCustomDbRolesResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasCustomDbRolesResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/custom_db_roles mongodbatlas_custom_db_roles}
*/
export declare class DataMongodbatlasCustomDbRoles extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_custom_db_roles";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/custom_db_roles mongodbatlas_custom_db_roles} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasCustomDbRolesConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasCustomDbRolesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasCustomDbRolesResultsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
