import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasDataLakeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/data_lake#id DataMongodbatlasDataLake#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/data_lake#name DataMongodbatlasDataLake#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/data_lake#project_id DataMongodbatlasDataLake#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasDataLakeAws {
}
export declare function dataMongodbatlasDataLakeAwsToTerraform(struct?: DataMongodbatlasDataLakeAws): any;
export declare class DataMongodbatlasDataLakeAwsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakeAws | undefined;
    set internalValue(value: DataMongodbatlasDataLakeAws | undefined);
    get externalId(): string;
    get iamAssumedRoleArn(): string;
    get iamUserArn(): string;
    get roleId(): string;
    get testS3Bucket(): string;
}
export declare class DataMongodbatlasDataLakeAwsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakeAwsOutputReference;
}
export interface DataMongodbatlasDataLakeDataProcessRegion {
}
export declare function dataMongodbatlasDataLakeDataProcessRegionToTerraform(struct?: DataMongodbatlasDataLakeDataProcessRegion): any;
export declare class DataMongodbatlasDataLakeDataProcessRegionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakeDataProcessRegion | undefined;
    set internalValue(value: DataMongodbatlasDataLakeDataProcessRegion | undefined);
    get cloudProvider(): string;
    get region(): string;
}
export declare class DataMongodbatlasDataLakeDataProcessRegionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakeDataProcessRegionOutputReference;
}
export interface DataMongodbatlasDataLakeStorageDatabasesCollectionsDataSources {
}
export declare function dataMongodbatlasDataLakeStorageDatabasesCollectionsDataSourcesToTerraform(struct?: DataMongodbatlasDataLakeStorageDatabasesCollectionsDataSources): any;
export declare class DataMongodbatlasDataLakeStorageDatabasesCollectionsDataSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakeStorageDatabasesCollectionsDataSources | undefined;
    set internalValue(value: DataMongodbatlasDataLakeStorageDatabasesCollectionsDataSources | undefined);
    get defaultFormat(): string;
    get path(): string;
    get storeName(): string;
}
export declare class DataMongodbatlasDataLakeStorageDatabasesCollectionsDataSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakeStorageDatabasesCollectionsDataSourcesOutputReference;
}
export interface DataMongodbatlasDataLakeStorageDatabasesCollections {
}
export declare function dataMongodbatlasDataLakeStorageDatabasesCollectionsToTerraform(struct?: DataMongodbatlasDataLakeStorageDatabasesCollections): any;
export declare class DataMongodbatlasDataLakeStorageDatabasesCollectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakeStorageDatabasesCollections | undefined;
    set internalValue(value: DataMongodbatlasDataLakeStorageDatabasesCollections | undefined);
    private _dataSources;
    get dataSources(): DataMongodbatlasDataLakeStorageDatabasesCollectionsDataSourcesList;
    get name(): string;
}
export declare class DataMongodbatlasDataLakeStorageDatabasesCollectionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakeStorageDatabasesCollectionsOutputReference;
}
export interface DataMongodbatlasDataLakeStorageDatabasesViews {
}
export declare function dataMongodbatlasDataLakeStorageDatabasesViewsToTerraform(struct?: DataMongodbatlasDataLakeStorageDatabasesViews): any;
export declare class DataMongodbatlasDataLakeStorageDatabasesViewsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakeStorageDatabasesViews | undefined;
    set internalValue(value: DataMongodbatlasDataLakeStorageDatabasesViews | undefined);
    get name(): string;
    get pipeline(): string;
    get source(): string;
}
export declare class DataMongodbatlasDataLakeStorageDatabasesViewsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakeStorageDatabasesViewsOutputReference;
}
export interface DataMongodbatlasDataLakeStorageDatabases {
}
export declare function dataMongodbatlasDataLakeStorageDatabasesToTerraform(struct?: DataMongodbatlasDataLakeStorageDatabases): any;
export declare class DataMongodbatlasDataLakeStorageDatabasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakeStorageDatabases | undefined;
    set internalValue(value: DataMongodbatlasDataLakeStorageDatabases | undefined);
    private _collections;
    get collections(): DataMongodbatlasDataLakeStorageDatabasesCollectionsList;
    get maxWildcardCollections(): number;
    get name(): string;
    private _views;
    get views(): DataMongodbatlasDataLakeStorageDatabasesViewsList;
}
export declare class DataMongodbatlasDataLakeStorageDatabasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakeStorageDatabasesOutputReference;
}
export interface DataMongodbatlasDataLakeStorageStores {
}
export declare function dataMongodbatlasDataLakeStorageStoresToTerraform(struct?: DataMongodbatlasDataLakeStorageStores): any;
export declare class DataMongodbatlasDataLakeStorageStoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakeStorageStores | undefined;
    set internalValue(value: DataMongodbatlasDataLakeStorageStores | undefined);
    get additionalStorageClasses(): string[];
    get bucket(): string;
    get delimiter(): string;
    get includeTags(): cdktf.IResolvable;
    get name(): string;
    get prefix(): string;
    get provider(): string;
    get region(): string;
}
export declare class DataMongodbatlasDataLakeStorageStoresList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakeStorageStoresOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/data_lake mongodbatlas_data_lake}
*/
export declare class DataMongodbatlasDataLake extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_data_lake";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/data_lake mongodbatlas_data_lake} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasDataLakeConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasDataLakeConfig);
    private _aws;
    get aws(): DataMongodbatlasDataLakeAwsList;
    private _dataProcessRegion;
    get dataProcessRegion(): DataMongodbatlasDataLakeDataProcessRegionList;
    get hostnames(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get state(): string;
    private _storageDatabases;
    get storageDatabases(): DataMongodbatlasDataLakeStorageDatabasesList;
    private _storageStores;
    get storageStores(): DataMongodbatlasDataLakeStorageStoresList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
