import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasDataLakesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/data_lakes#id DataMongodbatlasDataLakes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/data_lakes#project_id DataMongodbatlasDataLakes#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasDataLakesResultsAws {
}
export declare function dataMongodbatlasDataLakesResultsAwsToTerraform(struct?: DataMongodbatlasDataLakesResultsAws): any;
export declare class DataMongodbatlasDataLakesResultsAwsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakesResultsAws | undefined;
    set internalValue(value: DataMongodbatlasDataLakesResultsAws | undefined);
    get externalId(): string;
    get iamAssumedRoleArn(): string;
    get iamUserArn(): string;
    get roleId(): string;
    get testS3Bucket(): string;
}
export declare class DataMongodbatlasDataLakesResultsAwsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakesResultsAwsOutputReference;
}
export interface DataMongodbatlasDataLakesResultsDataProcessRegion {
}
export declare function dataMongodbatlasDataLakesResultsDataProcessRegionToTerraform(struct?: DataMongodbatlasDataLakesResultsDataProcessRegion): any;
export declare class DataMongodbatlasDataLakesResultsDataProcessRegionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakesResultsDataProcessRegion | undefined;
    set internalValue(value: DataMongodbatlasDataLakesResultsDataProcessRegion | undefined);
    get cloudProvider(): string;
    get region(): string;
}
export declare class DataMongodbatlasDataLakesResultsDataProcessRegionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakesResultsDataProcessRegionOutputReference;
}
export interface DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsDataSources {
}
export declare function dataMongodbatlasDataLakesResultsStorageDatabasesCollectionsDataSourcesToTerraform(struct?: DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsDataSources): any;
export declare class DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsDataSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsDataSources | undefined;
    set internalValue(value: DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsDataSources | undefined);
    get defaultFormat(): string;
    get path(): string;
    get storeName(): string;
}
export declare class DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsDataSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsDataSourcesOutputReference;
}
export interface DataMongodbatlasDataLakesResultsStorageDatabasesCollections {
}
export declare function dataMongodbatlasDataLakesResultsStorageDatabasesCollectionsToTerraform(struct?: DataMongodbatlasDataLakesResultsStorageDatabasesCollections): any;
export declare class DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakesResultsStorageDatabasesCollections | undefined;
    set internalValue(value: DataMongodbatlasDataLakesResultsStorageDatabasesCollections | undefined);
    private _dataSources;
    get dataSources(): DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsDataSourcesList;
    get name(): string;
}
export declare class DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsOutputReference;
}
export interface DataMongodbatlasDataLakesResultsStorageDatabasesViews {
}
export declare function dataMongodbatlasDataLakesResultsStorageDatabasesViewsToTerraform(struct?: DataMongodbatlasDataLakesResultsStorageDatabasesViews): any;
export declare class DataMongodbatlasDataLakesResultsStorageDatabasesViewsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakesResultsStorageDatabasesViews | undefined;
    set internalValue(value: DataMongodbatlasDataLakesResultsStorageDatabasesViews | undefined);
    get name(): string;
    get pipeline(): string;
    get source(): string;
}
export declare class DataMongodbatlasDataLakesResultsStorageDatabasesViewsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakesResultsStorageDatabasesViewsOutputReference;
}
export interface DataMongodbatlasDataLakesResultsStorageDatabases {
}
export declare function dataMongodbatlasDataLakesResultsStorageDatabasesToTerraform(struct?: DataMongodbatlasDataLakesResultsStorageDatabases): any;
export declare class DataMongodbatlasDataLakesResultsStorageDatabasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakesResultsStorageDatabases | undefined;
    set internalValue(value: DataMongodbatlasDataLakesResultsStorageDatabases | undefined);
    private _collections;
    get collections(): DataMongodbatlasDataLakesResultsStorageDatabasesCollectionsList;
    get maxWildcardCollections(): number;
    get name(): string;
    private _views;
    get views(): DataMongodbatlasDataLakesResultsStorageDatabasesViewsList;
}
export declare class DataMongodbatlasDataLakesResultsStorageDatabasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakesResultsStorageDatabasesOutputReference;
}
export interface DataMongodbatlasDataLakesResultsStorageStores {
}
export declare function dataMongodbatlasDataLakesResultsStorageStoresToTerraform(struct?: DataMongodbatlasDataLakesResultsStorageStores): any;
export declare class DataMongodbatlasDataLakesResultsStorageStoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakesResultsStorageStores | undefined;
    set internalValue(value: DataMongodbatlasDataLakesResultsStorageStores | undefined);
    get additionalStorageClasses(): string[];
    get bucket(): string;
    get delimiter(): string;
    get includeTags(): cdktf.IResolvable;
    get name(): string;
    get prefix(): string;
    get provider(): string;
    get region(): string;
}
export declare class DataMongodbatlasDataLakesResultsStorageStoresList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakesResultsStorageStoresOutputReference;
}
export interface DataMongodbatlasDataLakesResults {
}
export declare function dataMongodbatlasDataLakesResultsToTerraform(struct?: DataMongodbatlasDataLakesResults): any;
export declare class DataMongodbatlasDataLakesResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDataLakesResults | undefined;
    set internalValue(value: DataMongodbatlasDataLakesResults | undefined);
    private _aws;
    get aws(): DataMongodbatlasDataLakesResultsAwsList;
    private _dataProcessRegion;
    get dataProcessRegion(): DataMongodbatlasDataLakesResultsDataProcessRegionList;
    get hostnames(): string[];
    get name(): string;
    get projectId(): string;
    get state(): string;
    private _storageDatabases;
    get storageDatabases(): DataMongodbatlasDataLakesResultsStorageDatabasesList;
    private _storageStores;
    get storageStores(): DataMongodbatlasDataLakesResultsStorageStoresList;
}
export declare class DataMongodbatlasDataLakesResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDataLakesResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/data_lakes mongodbatlas_data_lakes}
*/
export declare class DataMongodbatlasDataLakes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_data_lakes";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/data_lakes mongodbatlas_data_lakes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasDataLakesConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasDataLakesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasDataLakesResultsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
