import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasDatabaseUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/database_user#auth_database_name DataMongodbatlasDatabaseUser#auth_database_name}
    */
    readonly authDatabaseName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/database_user#database_name DataMongodbatlasDatabaseUser#database_name}
    */
    readonly databaseName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/database_user#id DataMongodbatlasDatabaseUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/database_user#project_id DataMongodbatlasDatabaseUser#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/database_user#username DataMongodbatlasDatabaseUser#username}
    */
    readonly username: string;
}
export interface DataMongodbatlasDatabaseUserLabels {
}
export declare function dataMongodbatlasDatabaseUserLabelsToTerraform(struct?: DataMongodbatlasDatabaseUserLabels): any;
export declare class DataMongodbatlasDatabaseUserLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDatabaseUserLabels | undefined;
    set internalValue(value: DataMongodbatlasDatabaseUserLabels | undefined);
    get key(): string;
    get value(): string;
}
export declare class DataMongodbatlasDatabaseUserLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDatabaseUserLabelsOutputReference;
}
export interface DataMongodbatlasDatabaseUserRoles {
}
export declare function dataMongodbatlasDatabaseUserRolesToTerraform(struct?: DataMongodbatlasDatabaseUserRoles): any;
export declare class DataMongodbatlasDatabaseUserRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDatabaseUserRoles | undefined;
    set internalValue(value: DataMongodbatlasDatabaseUserRoles | undefined);
    get collectionName(): string;
    get databaseName(): string;
    get roleName(): string;
}
export declare class DataMongodbatlasDatabaseUserRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDatabaseUserRolesOutputReference;
}
export interface DataMongodbatlasDatabaseUserScopes {
}
export declare function dataMongodbatlasDatabaseUserScopesToTerraform(struct?: DataMongodbatlasDatabaseUserScopes): any;
export declare class DataMongodbatlasDatabaseUserScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDatabaseUserScopes | undefined;
    set internalValue(value: DataMongodbatlasDatabaseUserScopes | undefined);
    get name(): string;
    get type(): string;
}
export declare class DataMongodbatlasDatabaseUserScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDatabaseUserScopesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/database_user mongodbatlas_database_user}
*/
export declare class DataMongodbatlasDatabaseUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_database_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/database_user mongodbatlas_database_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasDatabaseUserConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasDatabaseUserConfig);
    private _authDatabaseName?;
    get authDatabaseName(): string;
    set authDatabaseName(value: string);
    resetAuthDatabaseName(): void;
    get authDatabaseNameInput(): string | undefined;
    get awsIamType(): string;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    resetDatabaseName(): void;
    get databaseNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): DataMongodbatlasDatabaseUserLabelsList;
    get ldapAuthType(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _roles;
    get roles(): DataMongodbatlasDatabaseUserRolesList;
    private _scopes;
    get scopes(): DataMongodbatlasDatabaseUserScopesList;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    get x509Type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
