import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasDatabaseUsersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/database_users#id DataMongodbatlasDatabaseUsers#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/database_users#project_id DataMongodbatlasDatabaseUsers#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasDatabaseUsersResultsLabels {
}
export declare function dataMongodbatlasDatabaseUsersResultsLabelsToTerraform(struct?: DataMongodbatlasDatabaseUsersResultsLabels): any;
export declare class DataMongodbatlasDatabaseUsersResultsLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDatabaseUsersResultsLabels | undefined;
    set internalValue(value: DataMongodbatlasDatabaseUsersResultsLabels | undefined);
    get key(): string;
    get value(): string;
}
export declare class DataMongodbatlasDatabaseUsersResultsLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDatabaseUsersResultsLabelsOutputReference;
}
export interface DataMongodbatlasDatabaseUsersResultsRoles {
}
export declare function dataMongodbatlasDatabaseUsersResultsRolesToTerraform(struct?: DataMongodbatlasDatabaseUsersResultsRoles): any;
export declare class DataMongodbatlasDatabaseUsersResultsRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDatabaseUsersResultsRoles | undefined;
    set internalValue(value: DataMongodbatlasDatabaseUsersResultsRoles | undefined);
    get collectionName(): string;
    get databaseName(): string;
    get roleName(): string;
}
export declare class DataMongodbatlasDatabaseUsersResultsRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDatabaseUsersResultsRolesOutputReference;
}
export interface DataMongodbatlasDatabaseUsersResultsScopes {
}
export declare function dataMongodbatlasDatabaseUsersResultsScopesToTerraform(struct?: DataMongodbatlasDatabaseUsersResultsScopes): any;
export declare class DataMongodbatlasDatabaseUsersResultsScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDatabaseUsersResultsScopes | undefined;
    set internalValue(value: DataMongodbatlasDatabaseUsersResultsScopes | undefined);
    get name(): string;
    get type(): string;
}
export declare class DataMongodbatlasDatabaseUsersResultsScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDatabaseUsersResultsScopesOutputReference;
}
export interface DataMongodbatlasDatabaseUsersResults {
}
export declare function dataMongodbatlasDatabaseUsersResultsToTerraform(struct?: DataMongodbatlasDatabaseUsersResults): any;
export declare class DataMongodbatlasDatabaseUsersResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasDatabaseUsersResults | undefined;
    set internalValue(value: DataMongodbatlasDatabaseUsersResults | undefined);
    get authDatabaseName(): string;
    get awsIamType(): string;
    private _labels;
    get labels(): DataMongodbatlasDatabaseUsersResultsLabelsList;
    get ldapAuthType(): string;
    get projectId(): string;
    private _roles;
    get roles(): DataMongodbatlasDatabaseUsersResultsRolesList;
    private _scopes;
    get scopes(): DataMongodbatlasDatabaseUsersResultsScopesList;
    get username(): string;
    get x509Type(): string;
}
export declare class DataMongodbatlasDatabaseUsersResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasDatabaseUsersResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/database_users mongodbatlas_database_users}
*/
export declare class DataMongodbatlasDatabaseUsers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_database_users";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/database_users mongodbatlas_database_users} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasDatabaseUsersConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasDatabaseUsersConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasDatabaseUsersResultsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
