import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasFederatedSettingsIdentityProviderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/federated_settings_identity_provider#federation_settings_id DataMongodbatlasFederatedSettingsIdentityProvider#federation_settings_id}
    */
    readonly federationSettingsId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/federated_settings_identity_provider#id DataMongodbatlasFederatedSettingsIdentityProvider#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/federated_settings_identity_provider#identity_provider_id DataMongodbatlasFederatedSettingsIdentityProvider#identity_provider_id}
    */
    readonly identityProviderId: string;
}
export interface DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsRoleAssignments {
}
export declare function dataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsRoleAssignmentsToTerraform(struct?: DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsRoleAssignments): any;
export declare class DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsRoleAssignmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsRoleAssignments | undefined;
    set internalValue(value: DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsRoleAssignments | undefined);
    get groupId(): string;
    get orgId(): string;
    get role(): string;
}
export declare class DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsRoleAssignmentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsRoleAssignmentsOutputReference;
}
export interface DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappings {
}
export declare function dataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsToTerraform(struct?: DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappings): any;
export declare class DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappings | undefined;
    set internalValue(value: DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappings | undefined);
    get externalGroupName(): string;
    get id(): string;
    private _roleAssignments;
    get roleAssignments(): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsRoleAssignmentsList;
}
export declare class DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsOutputReference;
}
export interface DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsUserConflicts {
}
export declare function dataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsUserConflictsToTerraform(struct?: DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsUserConflicts): any;
export declare class DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsUserConflictsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsUserConflicts | undefined;
    set internalValue(value: DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsUserConflicts | undefined);
    get emailAddress(): string;
    get federationSettingsId(): string;
    get firstName(): string;
    get lastName(): string;
    get userId(): string;
}
export declare class DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsUserConflictsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsUserConflictsOutputReference;
}
export interface DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgs {
}
export declare function dataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsToTerraform(struct?: DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgs): any;
export declare class DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgs | undefined;
    set internalValue(value: DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgs | undefined);
    get domainAllowList(): string[];
    get domainRestrictionEnabled(): cdktf.IResolvable;
    get identityProviderId(): string;
    get orgId(): string;
    get postAuthRoleGrants(): string[];
    private _roleMappings;
    get roleMappings(): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsRoleMappingsList;
    private _userConflicts;
    get userConflicts(): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsUserConflictsList;
}
export declare class DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsOutputReference;
}
export interface DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoCertificates {
}
export declare function dataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoCertificatesToTerraform(struct?: DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoCertificates): any;
export declare class DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoCertificates | undefined;
    set internalValue(value: DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoCertificates | undefined);
    get notAfter(): string;
    get notBefore(): string;
}
export declare class DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoCertificatesOutputReference;
}
export interface DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfo {
}
export declare function dataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoToTerraform(struct?: DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfo): any;
export declare class DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfo | undefined;
    set internalValue(value: DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfo | undefined);
    private _certificates;
    get certificates(): DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoCertificatesList;
    get fileName(): string;
}
export declare class DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/federated_settings_identity_provider mongodbatlas_federated_settings_identity_provider}
*/
export declare class DataMongodbatlasFederatedSettingsIdentityProvider extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_federated_settings_identity_provider";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/federated_settings_identity_provider mongodbatlas_federated_settings_identity_provider} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasFederatedSettingsIdentityProviderConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasFederatedSettingsIdentityProviderConfig);
    get acsUrl(): string;
    get associatedDomains(): string[];
    private _associatedOrgs;
    get associatedOrgs(): DataMongodbatlasFederatedSettingsIdentityProviderAssociatedOrgsList;
    get audienceUri(): string;
    get displayName(): string;
    private _federationSettingsId?;
    get federationSettingsId(): string;
    set federationSettingsId(value: string);
    get federationSettingsIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identityProviderId?;
    get identityProviderId(): string;
    set identityProviderId(value: string);
    get identityProviderIdInput(): string | undefined;
    get issuerUri(): string;
    get oktaIdpId(): string;
    private _pemFileInfo;
    get pemFileInfo(): DataMongodbatlasFederatedSettingsIdentityProviderPemFileInfoList;
    get requestBinding(): string;
    get responseSignatureAlgorithm(): string;
    get ssoDebugEnabled(): cdktf.IResolvable;
    get ssoUrl(): string;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
