import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasFederatedSettingsOrgConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/federated_settings_org_config#federation_settings_id DataMongodbatlasFederatedSettingsOrgConfig#federation_settings_id}
    */
    readonly federationSettingsId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/federated_settings_org_config#id DataMongodbatlasFederatedSettingsOrgConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/federated_settings_org_config#org_id DataMongodbatlasFederatedSettingsOrgConfig#org_id}
    */
    readonly orgId: string;
}
export interface DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsRoleAssignments {
}
export declare function dataMongodbatlasFederatedSettingsOrgConfigRoleMappingsRoleAssignmentsToTerraform(struct?: DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsRoleAssignments): any;
export declare class DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsRoleAssignmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsRoleAssignments | undefined;
    set internalValue(value: DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsRoleAssignments | undefined);
    get groupId(): string;
    get orgId(): string;
    get role(): string;
}
export declare class DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsRoleAssignmentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsRoleAssignmentsOutputReference;
}
export interface DataMongodbatlasFederatedSettingsOrgConfigRoleMappings {
}
export declare function dataMongodbatlasFederatedSettingsOrgConfigRoleMappingsToTerraform(struct?: DataMongodbatlasFederatedSettingsOrgConfigRoleMappings): any;
export declare class DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasFederatedSettingsOrgConfigRoleMappings | undefined;
    set internalValue(value: DataMongodbatlasFederatedSettingsOrgConfigRoleMappings | undefined);
    get externalGroupName(): string;
    get id(): string;
    private _roleAssignments;
    get roleAssignments(): DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsRoleAssignmentsList;
}
export declare class DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsOutputReference;
}
export interface DataMongodbatlasFederatedSettingsOrgConfigUserConflicts {
}
export declare function dataMongodbatlasFederatedSettingsOrgConfigUserConflictsToTerraform(struct?: DataMongodbatlasFederatedSettingsOrgConfigUserConflicts): any;
export declare class DataMongodbatlasFederatedSettingsOrgConfigUserConflictsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasFederatedSettingsOrgConfigUserConflicts | undefined;
    set internalValue(value: DataMongodbatlasFederatedSettingsOrgConfigUserConflicts | undefined);
    get emailAddress(): string;
    get federationSettingsId(): string;
    get firstName(): string;
    get lastName(): string;
    get userId(): string;
}
export declare class DataMongodbatlasFederatedSettingsOrgConfigUserConflictsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasFederatedSettingsOrgConfigUserConflictsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/federated_settings_org_config mongodbatlas_federated_settings_org_config}
*/
export declare class DataMongodbatlasFederatedSettingsOrgConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_federated_settings_org_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/federated_settings_org_config mongodbatlas_federated_settings_org_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasFederatedSettingsOrgConfigConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasFederatedSettingsOrgConfigConfig);
    get domainAllowList(): string[];
    get domainRestrictionEnabled(): cdktf.IResolvable;
    private _federationSettingsId?;
    get federationSettingsId(): string;
    set federationSettingsId(value: string);
    get federationSettingsIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get identityProviderId(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    get postAuthRoleGrants(): string[];
    private _roleMappings;
    get roleMappings(): DataMongodbatlasFederatedSettingsOrgConfigRoleMappingsList;
    private _userConflicts;
    get userConflicts(): DataMongodbatlasFederatedSettingsOrgConfigUserConflictsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
