import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasLdapConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/ldap_configuration#id DataMongodbatlasLdapConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/ldap_configuration#project_id DataMongodbatlasLdapConfiguration#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasLdapConfigurationUserToDnMapping {
}
export declare function dataMongodbatlasLdapConfigurationUserToDnMappingToTerraform(struct?: DataMongodbatlasLdapConfigurationUserToDnMapping): any;
export declare class DataMongodbatlasLdapConfigurationUserToDnMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasLdapConfigurationUserToDnMapping | undefined;
    set internalValue(value: DataMongodbatlasLdapConfigurationUserToDnMapping | undefined);
    get ldapQuery(): string;
    get match(): string;
    get substitution(): string;
}
export declare class DataMongodbatlasLdapConfigurationUserToDnMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasLdapConfigurationUserToDnMappingOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/ldap_configuration mongodbatlas_ldap_configuration}
*/
export declare class DataMongodbatlasLdapConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_ldap_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/ldap_configuration mongodbatlas_ldap_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasLdapConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasLdapConfigurationConfig);
    get authenticationEnabled(): cdktf.IResolvable;
    get authorizationEnabled(): cdktf.IResolvable;
    get authzQueryTemplate(): string;
    get bindPassword(): string;
    get bindUsername(): string;
    get caCertificate(): string;
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get port(): number;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _userToDnMapping;
    get userToDnMapping(): DataMongodbatlasLdapConfigurationUserToDnMappingList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
