import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasLdapVerifyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/ldap_verify#id DataMongodbatlasLdapVerify#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/ldap_verify#project_id DataMongodbatlasLdapVerify#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/ldap_verify#request_id DataMongodbatlasLdapVerify#request_id}
    */
    readonly requestId: string;
}
export interface DataMongodbatlasLdapVerifyLinks {
}
export declare function dataMongodbatlasLdapVerifyLinksToTerraform(struct?: DataMongodbatlasLdapVerifyLinks): any;
export declare class DataMongodbatlasLdapVerifyLinksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasLdapVerifyLinks | undefined;
    set internalValue(value: DataMongodbatlasLdapVerifyLinks | undefined);
    get href(): string;
    get rel(): string;
}
export declare class DataMongodbatlasLdapVerifyLinksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasLdapVerifyLinksOutputReference;
}
export interface DataMongodbatlasLdapVerifyValidations {
}
export declare function dataMongodbatlasLdapVerifyValidationsToTerraform(struct?: DataMongodbatlasLdapVerifyValidations): any;
export declare class DataMongodbatlasLdapVerifyValidationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasLdapVerifyValidations | undefined;
    set internalValue(value: DataMongodbatlasLdapVerifyValidations | undefined);
    get status(): string;
    get validationType(): string;
}
export declare class DataMongodbatlasLdapVerifyValidationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasLdapVerifyValidationsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/ldap_verify mongodbatlas_ldap_verify}
*/
export declare class DataMongodbatlasLdapVerify extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_ldap_verify";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/ldap_verify mongodbatlas_ldap_verify} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasLdapVerifyConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasLdapVerifyConfig);
    get bindUsername(): string;
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _links;
    get links(): DataMongodbatlasLdapVerifyLinksList;
    get port(): number;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _requestId?;
    get requestId(): string;
    set requestId(value: string);
    get requestIdInput(): string | undefined;
    get status(): string;
    private _validations;
    get validations(): DataMongodbatlasLdapVerifyValidationsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
