import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasNetworkContainerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_container#container_id DataMongodbatlasNetworkContainer#container_id}
    */
    readonly containerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_container#id DataMongodbatlasNetworkContainer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_container#project_id DataMongodbatlasNetworkContainer#project_id}
    */
    readonly projectId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_container mongodbatlas_network_container}
*/
export declare class DataMongodbatlasNetworkContainer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_network_container";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_container mongodbatlas_network_container} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasNetworkContainerConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasNetworkContainerConfig);
    get atlasCidrBlock(): string;
    get azureSubscriptionId(): string;
    private _containerId?;
    get containerId(): string;
    set containerId(value: string);
    get containerIdInput(): string | undefined;
    get gcpProjectId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get networkName(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get providerName(): string;
    get provisioned(): cdktf.IResolvable;
    get region(): string;
    get regionName(): string;
    get regions(): string[];
    get vnetName(): string;
    get vpcId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
