import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasNetworkContainersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_containers#id DataMongodbatlasNetworkContainers#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_containers#project_id DataMongodbatlasNetworkContainers#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_containers#provider_name DataMongodbatlasNetworkContainers#provider_name}
    */
    readonly providerName: string;
}
export interface DataMongodbatlasNetworkContainersResults {
}
export declare function dataMongodbatlasNetworkContainersResultsToTerraform(struct?: DataMongodbatlasNetworkContainersResults): any;
export declare class DataMongodbatlasNetworkContainersResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasNetworkContainersResults | undefined;
    set internalValue(value: DataMongodbatlasNetworkContainersResults | undefined);
    get atlasCidrBlock(): string;
    get azureSubscriptionId(): string;
    get gcpProjectId(): string;
    get id(): string;
    get networkName(): string;
    get providerName(): string;
    get provisioned(): cdktf.IResolvable;
    get region(): string;
    get regionName(): string;
    get regions(): string[];
    get vnetName(): string;
    get vpcId(): string;
}
export declare class DataMongodbatlasNetworkContainersResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasNetworkContainersResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_containers mongodbatlas_network_containers}
*/
export declare class DataMongodbatlasNetworkContainers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_network_containers";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_containers mongodbatlas_network_containers} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasNetworkContainersConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasNetworkContainersConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasNetworkContainersResultsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
