import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_peering#id DataMongodbatlasNetworkPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_peering#peering_id DataMongodbatlasNetworkPeering#peering_id}
    */
    readonly peeringId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_peering#project_id DataMongodbatlasNetworkPeering#project_id}
    */
    readonly projectId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_peering mongodbatlas_network_peering}
*/
export declare class DataMongodbatlasNetworkPeering extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_network_peering";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_peering mongodbatlas_network_peering} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasNetworkPeeringConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasNetworkPeeringConfig);
    get accepterRegionName(): string;
    get atlasCidrBlock(): string;
    get atlasId(): string;
    get awsAccountId(): string;
    get azureDirectoryId(): string;
    get azureSubscriptionId(): string;
    get connectionId(): string;
    get containerId(): string;
    get errorMessage(): string;
    get errorState(): string;
    get errorStateName(): string;
    get gcpProjectId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get networkName(): string;
    private _peeringId?;
    get peeringId(): string;
    set peeringId(value: string);
    get peeringIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get providerName(): string;
    get resourceGroupName(): string;
    get routeTableCidrBlock(): string;
    get status(): string;
    get statusName(): string;
    get vnetName(): string;
    get vpcId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
