import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasNetworkPeeringsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_peerings#id DataMongodbatlasNetworkPeerings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_peerings#project_id DataMongodbatlasNetworkPeerings#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasNetworkPeeringsResults {
}
export declare function dataMongodbatlasNetworkPeeringsResultsToTerraform(struct?: DataMongodbatlasNetworkPeeringsResults): any;
export declare class DataMongodbatlasNetworkPeeringsResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasNetworkPeeringsResults | undefined;
    set internalValue(value: DataMongodbatlasNetworkPeeringsResults | undefined);
    get accepterRegionName(): string;
    get atlasCidrBlock(): string;
    get awsAccountId(): string;
    get azureDirectoryId(): string;
    get azureSubscriptionId(): string;
    get connectionId(): string;
    get containerId(): string;
    get errorMessage(): string;
    get errorState(): string;
    get errorStateName(): string;
    get gcpProjectId(): string;
    get networkName(): string;
    get peeringId(): string;
    get providerName(): string;
    get resourceGroupName(): string;
    get routeTableCidrBlock(): string;
    get status(): string;
    get statusName(): string;
    get vnetName(): string;
    get vpcId(): string;
}
export declare class DataMongodbatlasNetworkPeeringsResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasNetworkPeeringsResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_peerings mongodbatlas_network_peerings}
*/
export declare class DataMongodbatlasNetworkPeerings extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_network_peerings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/network_peerings mongodbatlas_network_peerings} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasNetworkPeeringsConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasNetworkPeeringsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasNetworkPeeringsResultsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
