import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasOnlineArchiveConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/online_archive#archive_id DataMongodbatlasOnlineArchive#archive_id}
    */
    readonly archiveId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/online_archive#cluster_name DataMongodbatlasOnlineArchive#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/online_archive#id DataMongodbatlasOnlineArchive#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/online_archive#project_id DataMongodbatlasOnlineArchive#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasOnlineArchiveCriteria {
}
export declare function dataMongodbatlasOnlineArchiveCriteriaToTerraform(struct?: DataMongodbatlasOnlineArchiveCriteria): any;
export declare class DataMongodbatlasOnlineArchiveCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasOnlineArchiveCriteria | undefined;
    set internalValue(value: DataMongodbatlasOnlineArchiveCriteria | undefined);
    get dateField(): string;
    get dateFormat(): string;
    get expireAfterDays(): number;
    get query(): string;
    get type(): string;
}
export declare class DataMongodbatlasOnlineArchiveCriteriaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasOnlineArchiveCriteriaOutputReference;
}
export interface DataMongodbatlasOnlineArchivePartitionFields {
}
export declare function dataMongodbatlasOnlineArchivePartitionFieldsToTerraform(struct?: DataMongodbatlasOnlineArchivePartitionFields): any;
export declare class DataMongodbatlasOnlineArchivePartitionFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasOnlineArchivePartitionFields | undefined;
    set internalValue(value: DataMongodbatlasOnlineArchivePartitionFields | undefined);
    get fieldName(): string;
    get fieldType(): string;
    get order(): number;
}
export declare class DataMongodbatlasOnlineArchivePartitionFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasOnlineArchivePartitionFieldsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/online_archive mongodbatlas_online_archive}
*/
export declare class DataMongodbatlasOnlineArchive extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_online_archive";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/online_archive mongodbatlas_online_archive} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasOnlineArchiveConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasOnlineArchiveConfig);
    private _archiveId?;
    get archiveId(): string;
    set archiveId(value: string);
    get archiveIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    get collName(): string;
    get collectionType(): string;
    private _criteria;
    get criteria(): DataMongodbatlasOnlineArchiveCriteriaList;
    get dbName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _partitionFields;
    get partitionFields(): DataMongodbatlasOnlineArchivePartitionFieldsList;
    get paused(): cdktf.IResolvable;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get state(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
