import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasOnlineArchivesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/online_archives#cluster_name DataMongodbatlasOnlineArchives#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/online_archives#id DataMongodbatlasOnlineArchives#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/online_archives#project_id DataMongodbatlasOnlineArchives#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasOnlineArchivesResultsCriteria {
}
export declare function dataMongodbatlasOnlineArchivesResultsCriteriaToTerraform(struct?: DataMongodbatlasOnlineArchivesResultsCriteria): any;
export declare class DataMongodbatlasOnlineArchivesResultsCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasOnlineArchivesResultsCriteria | undefined;
    set internalValue(value: DataMongodbatlasOnlineArchivesResultsCriteria | undefined);
    get dateField(): string;
    get dateFormat(): string;
    get expireAfterDays(): number;
    get query(): string;
    get type(): string;
}
export declare class DataMongodbatlasOnlineArchivesResultsCriteriaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasOnlineArchivesResultsCriteriaOutputReference;
}
export interface DataMongodbatlasOnlineArchivesResultsPartitionFields {
}
export declare function dataMongodbatlasOnlineArchivesResultsPartitionFieldsToTerraform(struct?: DataMongodbatlasOnlineArchivesResultsPartitionFields): any;
export declare class DataMongodbatlasOnlineArchivesResultsPartitionFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasOnlineArchivesResultsPartitionFields | undefined;
    set internalValue(value: DataMongodbatlasOnlineArchivesResultsPartitionFields | undefined);
    get fieldName(): string;
    get fieldType(): string;
    get order(): number;
}
export declare class DataMongodbatlasOnlineArchivesResultsPartitionFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasOnlineArchivesResultsPartitionFieldsOutputReference;
}
export interface DataMongodbatlasOnlineArchivesResults {
}
export declare function dataMongodbatlasOnlineArchivesResultsToTerraform(struct?: DataMongodbatlasOnlineArchivesResults): any;
export declare class DataMongodbatlasOnlineArchivesResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasOnlineArchivesResults | undefined;
    set internalValue(value: DataMongodbatlasOnlineArchivesResults | undefined);
    get archiveId(): string;
    get clusterName(): string;
    get collName(): string;
    get collectionType(): string;
    private _criteria;
    get criteria(): DataMongodbatlasOnlineArchivesResultsCriteriaList;
    get dbName(): string;
    private _partitionFields;
    get partitionFields(): DataMongodbatlasOnlineArchivesResultsPartitionFieldsList;
    get paused(): cdktf.IResolvable;
    get projectId(): string;
    get state(): string;
}
export declare class DataMongodbatlasOnlineArchivesResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasOnlineArchivesResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/online_archives mongodbatlas_online_archives}
*/
export declare class DataMongodbatlasOnlineArchives extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_online_archives";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/online_archives mongodbatlas_online_archives} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasOnlineArchivesConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasOnlineArchivesConfig);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasOnlineArchivesResultsList;
    get totalCount(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
