import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasPrivatelinkEndpointServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint_service#endpoint_service_id DataMongodbatlasPrivatelinkEndpointService#endpoint_service_id}
    */
    readonly endpointServiceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint_service#id DataMongodbatlasPrivatelinkEndpointService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint_service#private_link_id DataMongodbatlasPrivatelinkEndpointService#private_link_id}
    */
    readonly privateLinkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint_service#project_id DataMongodbatlasPrivatelinkEndpointService#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint_service#provider_name DataMongodbatlasPrivatelinkEndpointService#provider_name}
    */
    readonly providerName: string;
}
export interface DataMongodbatlasPrivatelinkEndpointServiceEndpoints {
}
export declare function dataMongodbatlasPrivatelinkEndpointServiceEndpointsToTerraform(struct?: DataMongodbatlasPrivatelinkEndpointServiceEndpoints): any;
export declare class DataMongodbatlasPrivatelinkEndpointServiceEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasPrivatelinkEndpointServiceEndpoints | undefined;
    set internalValue(value: DataMongodbatlasPrivatelinkEndpointServiceEndpoints | undefined);
    get endpointName(): string;
    get ipAddress(): string;
    get serviceAttachmentName(): string;
    get status(): string;
}
export declare class DataMongodbatlasPrivatelinkEndpointServiceEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasPrivatelinkEndpointServiceEndpointsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint_service mongodbatlas_privatelink_endpoint_service}
*/
export declare class DataMongodbatlasPrivatelinkEndpointService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_privatelink_endpoint_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint_service mongodbatlas_privatelink_endpoint_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasPrivatelinkEndpointServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasPrivatelinkEndpointServiceConfig);
    get awsConnectionStatus(): string;
    get azureStatus(): string;
    get deleteRequested(): cdktf.IResolvable;
    private _endpointServiceId?;
    get endpointServiceId(): string;
    set endpointServiceId(value: string);
    get endpointServiceIdInput(): string | undefined;
    private _endpoints;
    get endpoints(): DataMongodbatlasPrivatelinkEndpointServiceEndpointsList;
    get errorMessage(): string;
    get gcpStatus(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get interfaceEndpointId(): string;
    get privateEndpointConnectionName(): string;
    get privateEndpointIpAddress(): string;
    get privateEndpointResourceId(): string;
    private _privateLinkId?;
    get privateLinkId(): string;
    set privateLinkId(value: string);
    get privateLinkIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
