import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasPrivatelinkEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint#id DataMongodbatlasPrivatelinkEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint#private_link_id DataMongodbatlasPrivatelinkEndpoint#private_link_id}
    */
    readonly privateLinkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint#project_id DataMongodbatlasPrivatelinkEndpoint#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint#provider_name DataMongodbatlasPrivatelinkEndpoint#provider_name}
    */
    readonly providerName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint mongodbatlas_privatelink_endpoint}
*/
export declare class DataMongodbatlasPrivatelinkEndpoint extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_privatelink_endpoint";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/privatelink_endpoint mongodbatlas_privatelink_endpoint} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasPrivatelinkEndpointConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasPrivatelinkEndpointConfig);
    get endpointGroupNames(): string[];
    get endpointServiceName(): string;
    get errorMessage(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get interfaceEndpoints(): string[];
    get privateEndpoints(): string[];
    private _privateLinkId?;
    get privateLinkId(): string;
    set privateLinkId(value: string);
    get privateLinkIdInput(): string | undefined;
    get privateLinkServiceName(): string;
    get privateLinkServiceResourceId(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    get regionName(): string;
    get serviceAttachmentNames(): string[];
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
