import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/project#id DataMongodbatlasProject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/project#name DataMongodbatlasProject#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/project#project_id DataMongodbatlasProject#project_id}
    */
    readonly projectId?: string;
}
export interface DataMongodbatlasProjectApiKeys {
}
export declare function dataMongodbatlasProjectApiKeysToTerraform(struct?: DataMongodbatlasProjectApiKeys): any;
export declare class DataMongodbatlasProjectApiKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasProjectApiKeys | undefined;
    set internalValue(value: DataMongodbatlasProjectApiKeys | undefined);
    get apiKeyId(): string;
    get roleNames(): string[];
}
export declare class DataMongodbatlasProjectApiKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasProjectApiKeysOutputReference;
}
export interface DataMongodbatlasProjectTeams {
}
export declare function dataMongodbatlasProjectTeamsToTerraform(struct?: DataMongodbatlasProjectTeams): any;
export declare class DataMongodbatlasProjectTeamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasProjectTeams | undefined;
    set internalValue(value: DataMongodbatlasProjectTeams | undefined);
    get roleNames(): string[];
    get teamId(): string;
}
export declare class DataMongodbatlasProjectTeamsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasProjectTeamsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/project mongodbatlas_project}
*/
export declare class DataMongodbatlasProject extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_project";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/project mongodbatlas_project} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasProjectConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataMongodbatlasProjectConfig);
    private _apiKeys;
    get apiKeys(): DataMongodbatlasProjectApiKeysList;
    get clusterCount(): number;
    get created(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get isCollectDatabaseSpecificsStatisticsEnabled(): cdktf.IResolvable;
    get isDataExplorerEnabled(): cdktf.IResolvable;
    get isPerformanceAdvisorEnabled(): cdktf.IResolvable;
    get isRealtimePerformancePanelEnabled(): cdktf.IResolvable;
    get isSchemaAdvisorEnabled(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get orgId(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    get regionUsageRestrictions(): string;
    private _teams;
    get teams(): DataMongodbatlasProjectTeamsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
