import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasProjectsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/projects#id DataMongodbatlasProjects#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/projects#items_per_page DataMongodbatlasProjects#items_per_page}
    */
    readonly itemsPerPage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/projects#page_num DataMongodbatlasProjects#page_num}
    */
    readonly pageNum?: number;
}
export interface DataMongodbatlasProjectsResultsApiKeys {
}
export declare function dataMongodbatlasProjectsResultsApiKeysToTerraform(struct?: DataMongodbatlasProjectsResultsApiKeys): any;
export declare class DataMongodbatlasProjectsResultsApiKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasProjectsResultsApiKeys | undefined;
    set internalValue(value: DataMongodbatlasProjectsResultsApiKeys | undefined);
    get apiKeyId(): string;
    get roleNames(): string[];
}
export declare class DataMongodbatlasProjectsResultsApiKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasProjectsResultsApiKeysOutputReference;
}
export interface DataMongodbatlasProjectsResultsTeams {
}
export declare function dataMongodbatlasProjectsResultsTeamsToTerraform(struct?: DataMongodbatlasProjectsResultsTeams): any;
export declare class DataMongodbatlasProjectsResultsTeamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasProjectsResultsTeams | undefined;
    set internalValue(value: DataMongodbatlasProjectsResultsTeams | undefined);
    get roleNames(): string[];
    get teamId(): string;
}
export declare class DataMongodbatlasProjectsResultsTeamsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasProjectsResultsTeamsOutputReference;
}
export interface DataMongodbatlasProjectsResults {
}
export declare function dataMongodbatlasProjectsResultsToTerraform(struct?: DataMongodbatlasProjectsResults): any;
export declare class DataMongodbatlasProjectsResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasProjectsResults | undefined;
    set internalValue(value: DataMongodbatlasProjectsResults | undefined);
    private _apiKeys;
    get apiKeys(): DataMongodbatlasProjectsResultsApiKeysList;
    get clusterCount(): number;
    get created(): string;
    get id(): string;
    get isCollectDatabaseSpecificsStatisticsEnabled(): cdktf.IResolvable;
    get isDataExplorerEnabled(): cdktf.IResolvable;
    get isPerformanceAdvisorEnabled(): cdktf.IResolvable;
    get isRealtimePerformancePanelEnabled(): cdktf.IResolvable;
    get isSchemaAdvisorEnabled(): cdktf.IResolvable;
    get name(): string;
    get orgId(): string;
    get regionUsageRestrictions(): string;
    private _teams;
    get teams(): DataMongodbatlasProjectsResultsTeamsList;
}
export declare class DataMongodbatlasProjectsResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasProjectsResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/projects mongodbatlas_projects}
*/
export declare class DataMongodbatlasProjects extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_projects";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/projects mongodbatlas_projects} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasProjectsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataMongodbatlasProjectsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _itemsPerPage?;
    get itemsPerPage(): number;
    set itemsPerPage(value: number);
    resetItemsPerPage(): void;
    get itemsPerPageInput(): number | undefined;
    private _pageNum?;
    get pageNum(): number;
    set pageNum(value: number);
    resetPageNum(): void;
    get pageNumInput(): number | undefined;
    private _results;
    get results(): DataMongodbatlasProjectsResultsList;
    get totalCount(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
