import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasSearchIndexConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#analyzer DataMongodbatlasSearchIndex#analyzer}
    */
    readonly analyzer?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#analyzers DataMongodbatlasSearchIndex#analyzers}
    */
    readonly analyzers?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#cluster_name DataMongodbatlasSearchIndex#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#collection_name DataMongodbatlasSearchIndex#collection_name}
    */
    readonly collectionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#database DataMongodbatlasSearchIndex#database}
    */
    readonly database?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#id DataMongodbatlasSearchIndex#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#index_id DataMongodbatlasSearchIndex#index_id}
    */
    readonly indexId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#mappings_dynamic DataMongodbatlasSearchIndex#mappings_dynamic}
    */
    readonly mappingsDynamic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#mappings_fields DataMongodbatlasSearchIndex#mappings_fields}
    */
    readonly mappingsFields?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#name DataMongodbatlasSearchIndex#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#project_id DataMongodbatlasSearchIndex#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#search_analyzer DataMongodbatlasSearchIndex#search_analyzer}
    */
    readonly searchAnalyzer?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index#status DataMongodbatlasSearchIndex#status}
    */
    readonly status?: string;
}
export interface DataMongodbatlasSearchIndexSynonyms {
}
export declare function dataMongodbatlasSearchIndexSynonymsToTerraform(struct?: DataMongodbatlasSearchIndexSynonyms): any;
export declare class DataMongodbatlasSearchIndexSynonymsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasSearchIndexSynonyms | undefined;
    set internalValue(value: DataMongodbatlasSearchIndexSynonyms | undefined);
    get analyzer(): string;
    get name(): string;
    get sourceCollection(): string;
}
export declare class DataMongodbatlasSearchIndexSynonymsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasSearchIndexSynonymsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index mongodbatlas_search_index}
*/
export declare class DataMongodbatlasSearchIndex extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_search_index";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_index mongodbatlas_search_index} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasSearchIndexConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasSearchIndexConfig);
    private _analyzer?;
    get analyzer(): string;
    set analyzer(value: string);
    resetAnalyzer(): void;
    get analyzerInput(): string | undefined;
    private _analyzers?;
    get analyzers(): string;
    set analyzers(value: string);
    resetAnalyzers(): void;
    get analyzersInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _collectionName?;
    get collectionName(): string;
    set collectionName(value: string);
    resetCollectionName(): void;
    get collectionNameInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _indexId?;
    get indexId(): string;
    set indexId(value: string);
    get indexIdInput(): string | undefined;
    private _mappingsDynamic?;
    get mappingsDynamic(): boolean | cdktf.IResolvable;
    set mappingsDynamic(value: boolean | cdktf.IResolvable);
    resetMappingsDynamic(): void;
    get mappingsDynamicInput(): boolean | cdktf.IResolvable | undefined;
    private _mappingsFields?;
    get mappingsFields(): string;
    set mappingsFields(value: string);
    resetMappingsFields(): void;
    get mappingsFieldsInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _searchAnalyzer?;
    get searchAnalyzer(): string;
    set searchAnalyzer(value: string);
    resetSearchAnalyzer(): void;
    get searchAnalyzerInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _synonyms;
    get synonyms(): DataMongodbatlasSearchIndexSynonymsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
