import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasSearchIndexesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_indexes#cluster_name DataMongodbatlasSearchIndexes#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_indexes#collection_name DataMongodbatlasSearchIndexes#collection_name}
    */
    readonly collectionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_indexes#database DataMongodbatlasSearchIndexes#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_indexes#id DataMongodbatlasSearchIndexes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_indexes#items_per_page DataMongodbatlasSearchIndexes#items_per_page}
    */
    readonly itemsPerPage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_indexes#page_num DataMongodbatlasSearchIndexes#page_num}
    */
    readonly pageNum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_indexes#project_id DataMongodbatlasSearchIndexes#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasSearchIndexesResultsSynonyms {
}
export declare function dataMongodbatlasSearchIndexesResultsSynonymsToTerraform(struct?: DataMongodbatlasSearchIndexesResultsSynonyms): any;
export declare class DataMongodbatlasSearchIndexesResultsSynonymsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasSearchIndexesResultsSynonyms | undefined;
    set internalValue(value: DataMongodbatlasSearchIndexesResultsSynonyms | undefined);
    get analyzer(): string;
    get name(): string;
    get sourceCollection(): string;
}
export declare class DataMongodbatlasSearchIndexesResultsSynonymsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasSearchIndexesResultsSynonymsOutputReference;
}
export interface DataMongodbatlasSearchIndexesResults {
}
export declare function dataMongodbatlasSearchIndexesResultsToTerraform(struct?: DataMongodbatlasSearchIndexesResults): any;
export declare class DataMongodbatlasSearchIndexesResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasSearchIndexesResults | undefined;
    set internalValue(value: DataMongodbatlasSearchIndexesResults | undefined);
    get analyzer(): string;
    get analyzers(): string;
    get clusterName(): string;
    get collectionName(): string;
    get database(): string;
    get indexId(): string;
    get mappingsDynamic(): cdktf.IResolvable;
    get mappingsFields(): string;
    get name(): string;
    get projectId(): string;
    get searchAnalyzer(): string;
    get status(): string;
    private _synonyms;
    get synonyms(): DataMongodbatlasSearchIndexesResultsSynonymsList;
    get waitForIndexBuildCompletion(): cdktf.IResolvable;
}
export declare class DataMongodbatlasSearchIndexesResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasSearchIndexesResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_indexes mongodbatlas_search_indexes}
*/
export declare class DataMongodbatlasSearchIndexes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_search_indexes";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/search_indexes mongodbatlas_search_indexes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasSearchIndexesConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasSearchIndexesConfig);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _collectionName?;
    get collectionName(): string;
    set collectionName(value: string);
    get collectionNameInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _itemsPerPage?;
    get itemsPerPage(): number;
    set itemsPerPage(value: number);
    resetItemsPerPage(): void;
    get itemsPerPageInput(): number | undefined;
    private _pageNum?;
    get pageNum(): number;
    set pageNum(value: number);
    resetPageNum(): void;
    get pageNumInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasSearchIndexesResultsList;
    get totalCount(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
