import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasServerlessInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/serverless_instance#continuous_backup_enabled DataMongodbatlasServerlessInstance#continuous_backup_enabled}
    */
    readonly continuousBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/serverless_instance#name DataMongodbatlasServerlessInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/serverless_instance#project_id DataMongodbatlasServerlessInstance#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/serverless_instance#state_name DataMongodbatlasServerlessInstance#state_name}
    */
    readonly stateName?: string;
    /**
    * links block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/serverless_instance#links DataMongodbatlasServerlessInstance#links}
    */
    readonly links?: DataMongodbatlasServerlessInstanceLinks[] | cdktf.IResolvable;
}
export interface DataMongodbatlasServerlessInstanceLinks {
}
export declare function dataMongodbatlasServerlessInstanceLinksToTerraform(struct?: DataMongodbatlasServerlessInstanceLinks | cdktf.IResolvable): any;
export declare class DataMongodbatlasServerlessInstanceLinksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasServerlessInstanceLinks | cdktf.IResolvable | undefined;
    set internalValue(value: DataMongodbatlasServerlessInstanceLinks | cdktf.IResolvable | undefined);
    get href(): string;
    get rel(): string;
}
export declare class DataMongodbatlasServerlessInstanceLinksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataMongodbatlasServerlessInstanceLinks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasServerlessInstanceLinksOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/serverless_instance mongodbatlas_serverless_instance}
*/
export declare class DataMongodbatlasServerlessInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_serverless_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/serverless_instance mongodbatlas_serverless_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasServerlessInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasServerlessInstanceConfig);
    get connectionStringsPrivateEndpointSrv(): string[];
    get connectionStringsStandardSrv(): string;
    private _continuousBackupEnabled?;
    get continuousBackupEnabled(): boolean | cdktf.IResolvable;
    set continuousBackupEnabled(value: boolean | cdktf.IResolvable);
    resetContinuousBackupEnabled(): void;
    get continuousBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get createDate(): string;
    get id(): string;
    get mongoDbVersion(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get providerSettingsBackingProviderName(): string;
    get providerSettingsProviderName(): string;
    get providerSettingsRegionName(): string;
    private _stateName?;
    get stateName(): string;
    set stateName(value: string);
    resetStateName(): void;
    get stateNameInput(): string | undefined;
    get terminationProtectionEnabled(): cdktf.IResolvable;
    private _links;
    get links(): DataMongodbatlasServerlessInstanceLinksList;
    putLinks(value: DataMongodbatlasServerlessInstanceLinks[] | cdktf.IResolvable): void;
    resetLinks(): void;
    get linksInput(): cdktf.IResolvable | DataMongodbatlasServerlessInstanceLinks[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
