import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasServerlessInstancesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/serverless_instances#id DataMongodbatlasServerlessInstances#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/serverless_instances#project_id DataMongodbatlasServerlessInstances#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasServerlessInstancesResultsLinks {
}
export declare function dataMongodbatlasServerlessInstancesResultsLinksToTerraform(struct?: DataMongodbatlasServerlessInstancesResultsLinks): any;
export declare class DataMongodbatlasServerlessInstancesResultsLinksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasServerlessInstancesResultsLinks | undefined;
    set internalValue(value: DataMongodbatlasServerlessInstancesResultsLinks | undefined);
    get href(): string;
    get rel(): string;
}
export declare class DataMongodbatlasServerlessInstancesResultsLinksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasServerlessInstancesResultsLinksOutputReference;
}
export interface DataMongodbatlasServerlessInstancesResults {
}
export declare function dataMongodbatlasServerlessInstancesResultsToTerraform(struct?: DataMongodbatlasServerlessInstancesResults): any;
export declare class DataMongodbatlasServerlessInstancesResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasServerlessInstancesResults | undefined;
    set internalValue(value: DataMongodbatlasServerlessInstancesResults | undefined);
    get connectionStringsPrivateEndpointSrv(): string[];
    get connectionStringsStandardSrv(): string;
    get continuousBackupEnabled(): cdktf.IResolvable;
    get createDate(): string;
    get id(): string;
    private _links;
    get links(): DataMongodbatlasServerlessInstancesResultsLinksList;
    get mongoDbVersion(): string;
    get name(): string;
    get projectId(): string;
    get providerSettingsBackingProviderName(): string;
    get providerSettingsProviderName(): string;
    get providerSettingsRegionName(): string;
    get stateName(): string;
    get terminationProtectionEnabled(): cdktf.IResolvable;
}
export declare class DataMongodbatlasServerlessInstancesResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasServerlessInstancesResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/serverless_instances mongodbatlas_serverless_instances}
*/
export declare class DataMongodbatlasServerlessInstances extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_serverless_instances";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/serverless_instances mongodbatlas_serverless_instances} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasServerlessInstancesConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasServerlessInstancesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasServerlessInstancesResultsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
