import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasThirdPartyIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integration#enabled DataMongodbatlasThirdPartyIntegration#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integration#id DataMongodbatlasThirdPartyIntegration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integration#microsoft_teams_webhook_url DataMongodbatlasThirdPartyIntegration#microsoft_teams_webhook_url}
    */
    readonly microsoftTeamsWebhookUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integration#project_id DataMongodbatlasThirdPartyIntegration#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integration#scheme DataMongodbatlasThirdPartyIntegration#scheme}
    */
    readonly scheme?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integration#service_discovery DataMongodbatlasThirdPartyIntegration#service_discovery}
    */
    readonly serviceDiscovery?: string;
    /**
    * Third-party service integration identifier
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integration#type DataMongodbatlasThirdPartyIntegration#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integration#user_name DataMongodbatlasThirdPartyIntegration#user_name}
    */
    readonly userName?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integration mongodbatlas_third_party_integration}
*/
export declare class DataMongodbatlasThirdPartyIntegration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_third_party_integration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integration mongodbatlas_third_party_integration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasThirdPartyIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasThirdPartyIntegrationConfig);
    get accountId(): string;
    get apiKey(): string;
    get apiToken(): string;
    get channelName(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get flowName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get licenseKey(): string;
    private _microsoftTeamsWebhookUrl?;
    get microsoftTeamsWebhookUrl(): string;
    set microsoftTeamsWebhookUrl(value: string);
    resetMicrosoftTeamsWebhookUrl(): void;
    get microsoftTeamsWebhookUrlInput(): string | undefined;
    get orgName(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get readToken(): string;
    get region(): string;
    get routingKey(): string;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    get secret(): string;
    private _serviceDiscovery?;
    get serviceDiscovery(): string;
    set serviceDiscovery(value: string);
    resetServiceDiscovery(): void;
    get serviceDiscoveryInput(): string | undefined;
    get serviceKey(): string;
    get teamName(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get url(): string;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    get writeToken(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
