import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasThirdPartyIntegrationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integrations#id DataMongodbatlasThirdPartyIntegrations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integrations#project_id DataMongodbatlasThirdPartyIntegrations#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasThirdPartyIntegrationsResults {
}
export declare function dataMongodbatlasThirdPartyIntegrationsResultsToTerraform(struct?: DataMongodbatlasThirdPartyIntegrationsResults): any;
export declare class DataMongodbatlasThirdPartyIntegrationsResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasThirdPartyIntegrationsResults | undefined;
    set internalValue(value: DataMongodbatlasThirdPartyIntegrationsResults | undefined);
    get accountId(): string;
    get apiKey(): string;
    get apiToken(): string;
    get channelName(): string;
    get enabled(): cdktf.IResolvable;
    get flowName(): string;
    get licenseKey(): string;
    get microsoftTeamsWebhookUrl(): string;
    get orgName(): string;
    get projectId(): string;
    get readToken(): string;
    get region(): string;
    get routingKey(): string;
    get scheme(): string;
    get secret(): string;
    get serviceDiscovery(): string;
    get serviceKey(): string;
    get teamName(): string;
    get type(): string;
    get url(): string;
    get userName(): string;
    get writeToken(): string;
}
export declare class DataMongodbatlasThirdPartyIntegrationsResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasThirdPartyIntegrationsResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integrations mongodbatlas_third_party_integrations}
*/
export declare class DataMongodbatlasThirdPartyIntegrations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_third_party_integrations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/third_party_integrations mongodbatlas_third_party_integrations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasThirdPartyIntegrationsConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasThirdPartyIntegrationsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasThirdPartyIntegrationsResultsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
