import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasX509AuthenticationDatabaseUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/x509_authentication_database_user#id DataMongodbatlasX509AuthenticationDatabaseUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/x509_authentication_database_user#project_id DataMongodbatlasX509AuthenticationDatabaseUser#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/x509_authentication_database_user#username DataMongodbatlasX509AuthenticationDatabaseUser#username}
    */
    readonly username?: string;
}
export interface DataMongodbatlasX509AuthenticationDatabaseUserCertificates {
}
export declare function dataMongodbatlasX509AuthenticationDatabaseUserCertificatesToTerraform(struct?: DataMongodbatlasX509AuthenticationDatabaseUserCertificates): any;
export declare class DataMongodbatlasX509AuthenticationDatabaseUserCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasX509AuthenticationDatabaseUserCertificates | undefined;
    set internalValue(value: DataMongodbatlasX509AuthenticationDatabaseUserCertificates | undefined);
    get createdAt(): string;
    get groupId(): string;
    get id(): number;
    get notAfter(): string;
    get subject(): string;
}
export declare class DataMongodbatlasX509AuthenticationDatabaseUserCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasX509AuthenticationDatabaseUserCertificatesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/x509_authentication_database_user mongodbatlas_x509_authentication_database_user}
*/
export declare class DataMongodbatlasX509AuthenticationDatabaseUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_x509_authentication_database_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/x509_authentication_database_user mongodbatlas_x509_authentication_database_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasX509AuthenticationDatabaseUserConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasX509AuthenticationDatabaseUserConfig);
    private _certificates;
    get certificates(): DataMongodbatlasX509AuthenticationDatabaseUserCertificatesList;
    get customerX509Cas(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
