import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EncryptionAtRestConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#aws_kms EncryptionAtRest#aws_kms}
    */
    readonly awsKms?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_key_vault EncryptionAtRest#azure_key_vault}
    */
    readonly azureKeyVault?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#google_cloud_kms EncryptionAtRest#google_cloud_kms}
    */
    readonly googleCloudKms?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#id EncryptionAtRest#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#project_id EncryptionAtRest#project_id}
    */
    readonly projectId: string;
    /**
    * aws_kms_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#aws_kms_config EncryptionAtRest#aws_kms_config}
    */
    readonly awsKmsConfig?: EncryptionAtRestAwsKmsConfig;
    /**
    * azure_key_vault_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_key_vault_config EncryptionAtRest#azure_key_vault_config}
    */
    readonly azureKeyVaultConfig?: EncryptionAtRestAzureKeyVaultConfig;
    /**
    * google_cloud_kms_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#google_cloud_kms_config EncryptionAtRest#google_cloud_kms_config}
    */
    readonly googleCloudKmsConfig?: EncryptionAtRestGoogleCloudKmsConfig;
}
export interface EncryptionAtRestAwsKmsConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#access_key_id EncryptionAtRest#access_key_id}
    */
    readonly accessKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#customer_master_key_id EncryptionAtRest#customer_master_key_id}
    */
    readonly customerMasterKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#region EncryptionAtRest#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#role_id EncryptionAtRest#role_id}
    */
    readonly roleId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#secret_access_key EncryptionAtRest#secret_access_key}
    */
    readonly secretAccessKey?: string;
}
export declare function encryptionAtRestAwsKmsConfigToTerraform(struct?: EncryptionAtRestAwsKmsConfigOutputReference | EncryptionAtRestAwsKmsConfig): any;
export declare class EncryptionAtRestAwsKmsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EncryptionAtRestAwsKmsConfig | undefined;
    set internalValue(value: EncryptionAtRestAwsKmsConfig | undefined);
    private _accessKeyId?;
    get accessKeyId(): string;
    set accessKeyId(value: string);
    resetAccessKeyId(): void;
    get accessKeyIdInput(): string | undefined;
    private _customerMasterKeyId?;
    get customerMasterKeyId(): string;
    set customerMasterKeyId(value: string);
    resetCustomerMasterKeyId(): void;
    get customerMasterKeyIdInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    resetRoleId(): void;
    get roleIdInput(): string | undefined;
    private _secretAccessKey?;
    get secretAccessKey(): string;
    set secretAccessKey(value: string);
    resetSecretAccessKey(): void;
    get secretAccessKeyInput(): string | undefined;
}
export interface EncryptionAtRestAzureKeyVaultConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_environment EncryptionAtRest#azure_environment}
    */
    readonly azureEnvironment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#client_id EncryptionAtRest#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_identifier EncryptionAtRest#key_identifier}
    */
    readonly keyIdentifier?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_vault_name EncryptionAtRest#key_vault_name}
    */
    readonly keyVaultName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#resource_group_name EncryptionAtRest#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#secret EncryptionAtRest#secret}
    */
    readonly secret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#subscription_id EncryptionAtRest#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#tenant_id EncryptionAtRest#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function encryptionAtRestAzureKeyVaultConfigToTerraform(struct?: EncryptionAtRestAzureKeyVaultConfigOutputReference | EncryptionAtRestAzureKeyVaultConfig): any;
export declare class EncryptionAtRestAzureKeyVaultConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EncryptionAtRestAzureKeyVaultConfig | undefined;
    set internalValue(value: EncryptionAtRestAzureKeyVaultConfig | undefined);
    private _azureEnvironment?;
    get azureEnvironment(): string;
    set azureEnvironment(value: string);
    resetAzureEnvironment(): void;
    get azureEnvironmentInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keyIdentifier?;
    get keyIdentifier(): string;
    set keyIdentifier(value: string);
    resetKeyIdentifier(): void;
    get keyIdentifierInput(): string | undefined;
    private _keyVaultName?;
    get keyVaultName(): string;
    set keyVaultName(value: string);
    resetKeyVaultName(): void;
    get keyVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    resetSecret(): void;
    get secretInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export interface EncryptionAtRestGoogleCloudKmsConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_version_resource_id EncryptionAtRest#key_version_resource_id}
    */
    readonly keyVersionResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#service_account_key EncryptionAtRest#service_account_key}
    */
    readonly serviceAccountKey?: string;
}
export declare function encryptionAtRestGoogleCloudKmsConfigToTerraform(struct?: EncryptionAtRestGoogleCloudKmsConfigOutputReference | EncryptionAtRestGoogleCloudKmsConfig): any;
export declare class EncryptionAtRestGoogleCloudKmsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EncryptionAtRestGoogleCloudKmsConfig | undefined;
    set internalValue(value: EncryptionAtRestGoogleCloudKmsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVersionResourceId?;
    get keyVersionResourceId(): string;
    set keyVersionResourceId(value: string);
    resetKeyVersionResourceId(): void;
    get keyVersionResourceIdInput(): string | undefined;
    private _serviceAccountKey?;
    get serviceAccountKey(): string;
    set serviceAccountKey(value: string);
    resetServiceAccountKey(): void;
    get serviceAccountKeyInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest mongodbatlas_encryption_at_rest}
*/
export declare class EncryptionAtRest extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_encryption_at_rest";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest mongodbatlas_encryption_at_rest} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EncryptionAtRestConfig
    */
    constructor(scope: Construct, id: string, config: EncryptionAtRestConfig);
    private _awsKms?;
    get awsKms(): {
        [key: string]: string;
    };
    set awsKms(value: {
        [key: string]: string;
    });
    resetAwsKms(): void;
    get awsKmsInput(): {
        [key: string]: string;
    } | undefined;
    private _azureKeyVault?;
    get azureKeyVault(): {
        [key: string]: string;
    };
    set azureKeyVault(value: {
        [key: string]: string;
    });
    resetAzureKeyVault(): void;
    get azureKeyVaultInput(): {
        [key: string]: string;
    } | undefined;
    private _googleCloudKms?;
    get googleCloudKms(): {
        [key: string]: string;
    };
    set googleCloudKms(value: {
        [key: string]: string;
    });
    resetGoogleCloudKms(): void;
    get googleCloudKmsInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _awsKmsConfig;
    get awsKmsConfig(): EncryptionAtRestAwsKmsConfigOutputReference;
    putAwsKmsConfig(value: EncryptionAtRestAwsKmsConfig): void;
    resetAwsKmsConfig(): void;
    get awsKmsConfigInput(): EncryptionAtRestAwsKmsConfig | undefined;
    private _azureKeyVaultConfig;
    get azureKeyVaultConfig(): EncryptionAtRestAzureKeyVaultConfigOutputReference;
    putAzureKeyVaultConfig(value: EncryptionAtRestAzureKeyVaultConfig): void;
    resetAzureKeyVaultConfig(): void;
    get azureKeyVaultConfigInput(): EncryptionAtRestAzureKeyVaultConfig | undefined;
    private _googleCloudKmsConfig;
    get googleCloudKmsConfig(): EncryptionAtRestGoogleCloudKmsConfigOutputReference;
    putGoogleCloudKmsConfig(value: EncryptionAtRestGoogleCloudKmsConfig): void;
    resetGoogleCloudKmsConfig(): void;
    get googleCloudKmsConfigInput(): EncryptionAtRestGoogleCloudKmsConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
