import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#app_id EventTrigger#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_collection EventTrigger#config_collection}
    */
    readonly configCollection?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_database EventTrigger#config_database}
    */
    readonly configDatabase?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_full_document EventTrigger#config_full_document}
    */
    readonly configFullDocument?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_full_document_before EventTrigger#config_full_document_before}
    */
    readonly configFullDocumentBefore?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_match EventTrigger#config_match}
    */
    readonly configMatch?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_operation_type EventTrigger#config_operation_type}
    */
    readonly configOperationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_operation_types EventTrigger#config_operation_types}
    */
    readonly configOperationTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_project EventTrigger#config_project}
    */
    readonly configProject?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_providers EventTrigger#config_providers}
    */
    readonly configProviders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_schedule EventTrigger#config_schedule}
    */
    readonly configSchedule?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_service_id EventTrigger#config_service_id}
    */
    readonly configServiceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#disabled EventTrigger#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#function_id EventTrigger#function_id}
    */
    readonly functionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#id EventTrigger#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#name EventTrigger#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#project_id EventTrigger#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#type EventTrigger#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#unordered EventTrigger#unordered}
    */
    readonly unordered?: boolean | cdktf.IResolvable;
    /**
    * event_processors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#event_processors EventTrigger#event_processors}
    */
    readonly eventProcessors?: EventTriggerEventProcessors;
}
export interface EventTriggerEventProcessorsAwsEventbridge {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_account_id EventTrigger#config_account_id}
    */
    readonly configAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#config_region EventTrigger#config_region}
    */
    readonly configRegion?: string;
}
export declare function eventTriggerEventProcessorsAwsEventbridgeToTerraform(struct?: EventTriggerEventProcessorsAwsEventbridgeOutputReference | EventTriggerEventProcessorsAwsEventbridge): any;
export declare class EventTriggerEventProcessorsAwsEventbridgeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventTriggerEventProcessorsAwsEventbridge | undefined;
    set internalValue(value: EventTriggerEventProcessorsAwsEventbridge | undefined);
    private _configAccountId?;
    get configAccountId(): string;
    set configAccountId(value: string);
    resetConfigAccountId(): void;
    get configAccountIdInput(): string | undefined;
    private _configRegion?;
    get configRegion(): string;
    set configRegion(value: string);
    resetConfigRegion(): void;
    get configRegionInput(): string | undefined;
}
export interface EventTriggerEventProcessors {
    /**
    * aws_eventbridge block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger#aws_eventbridge EventTrigger#aws_eventbridge}
    */
    readonly awsEventbridge?: EventTriggerEventProcessorsAwsEventbridge;
}
export declare function eventTriggerEventProcessorsToTerraform(struct?: EventTriggerEventProcessorsOutputReference | EventTriggerEventProcessors): any;
export declare class EventTriggerEventProcessorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventTriggerEventProcessors | undefined;
    set internalValue(value: EventTriggerEventProcessors | undefined);
    private _awsEventbridge;
    get awsEventbridge(): EventTriggerEventProcessorsAwsEventbridgeOutputReference;
    putAwsEventbridge(value: EventTriggerEventProcessorsAwsEventbridge): void;
    resetAwsEventbridge(): void;
    get awsEventbridgeInput(): EventTriggerEventProcessorsAwsEventbridge | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger mongodbatlas_event_trigger}
*/
export declare class EventTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_event_trigger";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/event_trigger mongodbatlas_event_trigger} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventTriggerConfig
    */
    constructor(scope: Construct, id: string, config: EventTriggerConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _configCollection?;
    get configCollection(): string;
    set configCollection(value: string);
    resetConfigCollection(): void;
    get configCollectionInput(): string | undefined;
    private _configDatabase?;
    get configDatabase(): string;
    set configDatabase(value: string);
    resetConfigDatabase(): void;
    get configDatabaseInput(): string | undefined;
    private _configFullDocument?;
    get configFullDocument(): boolean | cdktf.IResolvable;
    set configFullDocument(value: boolean | cdktf.IResolvable);
    resetConfigFullDocument(): void;
    get configFullDocumentInput(): boolean | cdktf.IResolvable | undefined;
    private _configFullDocumentBefore?;
    get configFullDocumentBefore(): boolean | cdktf.IResolvable;
    set configFullDocumentBefore(value: boolean | cdktf.IResolvable);
    resetConfigFullDocumentBefore(): void;
    get configFullDocumentBeforeInput(): boolean | cdktf.IResolvable | undefined;
    private _configMatch?;
    get configMatch(): string;
    set configMatch(value: string);
    resetConfigMatch(): void;
    get configMatchInput(): string | undefined;
    private _configOperationType?;
    get configOperationType(): string;
    set configOperationType(value: string);
    resetConfigOperationType(): void;
    get configOperationTypeInput(): string | undefined;
    private _configOperationTypes?;
    get configOperationTypes(): string[];
    set configOperationTypes(value: string[]);
    resetConfigOperationTypes(): void;
    get configOperationTypesInput(): string[] | undefined;
    private _configProject?;
    get configProject(): string;
    set configProject(value: string);
    resetConfigProject(): void;
    get configProjectInput(): string | undefined;
    private _configProviders?;
    get configProviders(): string[];
    set configProviders(value: string[]);
    resetConfigProviders(): void;
    get configProvidersInput(): string[] | undefined;
    private _configSchedule?;
    get configSchedule(): string;
    set configSchedule(value: string);
    resetConfigSchedule(): void;
    get configScheduleInput(): string | undefined;
    get configScheduleType(): string;
    private _configServiceId?;
    get configServiceId(): string;
    set configServiceId(value: string);
    resetConfigServiceId(): void;
    get configServiceIdInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _functionId?;
    get functionId(): string;
    set functionId(value: string);
    resetFunctionId(): void;
    get functionIdInput(): string | undefined;
    get functionName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get triggerId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _unordered?;
    get unordered(): boolean | cdktf.IResolvable;
    set unordered(value: boolean | cdktf.IResolvable);
    resetUnordered(): void;
    get unorderedInput(): boolean | cdktf.IResolvable | undefined;
    private _eventProcessors;
    get eventProcessors(): EventTriggerEventProcessorsOutputReference;
    putEventProcessors(value: EventTriggerEventProcessors): void;
    resetEventProcessors(): void;
    get eventProcessorsInput(): EventTriggerEventProcessors | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
