import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FederatedSettingsIdentityProviderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider#associated_domains FederatedSettingsIdentityProvider#associated_domains}
    */
    readonly associatedDomains?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider#federation_settings_id FederatedSettingsIdentityProvider#federation_settings_id}
    */
    readonly federationSettingsId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider#id FederatedSettingsIdentityProvider#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider#issuer_uri FederatedSettingsIdentityProvider#issuer_uri}
    */
    readonly issuerUri: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider#name FederatedSettingsIdentityProvider#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider#request_binding FederatedSettingsIdentityProvider#request_binding}
    */
    readonly requestBinding: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider#response_signature_algorithm FederatedSettingsIdentityProvider#response_signature_algorithm}
    */
    readonly responseSignatureAlgorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider#sso_debug_enabled FederatedSettingsIdentityProvider#sso_debug_enabled}
    */
    readonly ssoDebugEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider#sso_url FederatedSettingsIdentityProvider#sso_url}
    */
    readonly ssoUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider#status FederatedSettingsIdentityProvider#status}
    */
    readonly status: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider mongodbatlas_federated_settings_identity_provider}
*/
export declare class FederatedSettingsIdentityProvider extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_federated_settings_identity_provider";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_identity_provider mongodbatlas_federated_settings_identity_provider} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FederatedSettingsIdentityProviderConfig
    */
    constructor(scope: Construct, id: string, config: FederatedSettingsIdentityProviderConfig);
    private _associatedDomains?;
    get associatedDomains(): string[];
    set associatedDomains(value: string[]);
    resetAssociatedDomains(): void;
    get associatedDomainsInput(): string[] | undefined;
    private _federationSettingsId?;
    get federationSettingsId(): string;
    set federationSettingsId(value: string);
    get federationSettingsIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuerUri?;
    get issuerUri(): string;
    set issuerUri(value: string);
    get issuerUriInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get oktaIdpId(): string;
    private _requestBinding?;
    get requestBinding(): string;
    set requestBinding(value: string);
    get requestBindingInput(): string | undefined;
    private _responseSignatureAlgorithm?;
    get responseSignatureAlgorithm(): string;
    set responseSignatureAlgorithm(value: string);
    get responseSignatureAlgorithmInput(): string | undefined;
    private _ssoDebugEnabled?;
    get ssoDebugEnabled(): boolean | cdktf.IResolvable;
    set ssoDebugEnabled(value: boolean | cdktf.IResolvable);
    get ssoDebugEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ssoUrl?;
    get ssoUrl(): string;
    set ssoUrl(value: string);
    get ssoUrlInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    get statusInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
