import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FederatedSettingsOrgConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_config#domain_allow_list FederatedSettingsOrgConfig#domain_allow_list}
    */
    readonly domainAllowList?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_config#domain_restriction_enabled FederatedSettingsOrgConfig#domain_restriction_enabled}
    */
    readonly domainRestrictionEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_config#federation_settings_id FederatedSettingsOrgConfig#federation_settings_id}
    */
    readonly federationSettingsId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_config#id FederatedSettingsOrgConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_config#identity_provider_id FederatedSettingsOrgConfig#identity_provider_id}
    */
    readonly identityProviderId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_config#org_id FederatedSettingsOrgConfig#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_config#post_auth_role_grants FederatedSettingsOrgConfig#post_auth_role_grants}
    */
    readonly postAuthRoleGrants?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_config mongodbatlas_federated_settings_org_config}
*/
export declare class FederatedSettingsOrgConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_federated_settings_org_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_config mongodbatlas_federated_settings_org_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FederatedSettingsOrgConfigConfig
    */
    constructor(scope: Construct, id: string, config: FederatedSettingsOrgConfigConfig);
    private _domainAllowList?;
    get domainAllowList(): string[];
    set domainAllowList(value: string[]);
    resetDomainAllowList(): void;
    get domainAllowListInput(): string[] | undefined;
    private _domainRestrictionEnabled?;
    get domainRestrictionEnabled(): boolean | cdktf.IResolvable;
    set domainRestrictionEnabled(value: boolean | cdktf.IResolvable);
    get domainRestrictionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _federationSettingsId?;
    get federationSettingsId(): string;
    set federationSettingsId(value: string);
    get federationSettingsIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identityProviderId?;
    get identityProviderId(): string;
    set identityProviderId(value: string);
    get identityProviderIdInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _postAuthRoleGrants?;
    get postAuthRoleGrants(): string[];
    set postAuthRoleGrants(value: string[]);
    resetPostAuthRoleGrants(): void;
    get postAuthRoleGrantsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
