import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FederatedSettingsOrgRoleMappingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_role_mapping#external_group_name FederatedSettingsOrgRoleMapping#external_group_name}
    */
    readonly externalGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_role_mapping#federation_settings_id FederatedSettingsOrgRoleMapping#federation_settings_id}
    */
    readonly federationSettingsId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_role_mapping#org_id FederatedSettingsOrgRoleMapping#org_id}
    */
    readonly orgId: string;
    /**
    * role_assignments block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_role_mapping#role_assignments FederatedSettingsOrgRoleMapping#role_assignments}
    */
    readonly roleAssignments: FederatedSettingsOrgRoleMappingRoleAssignments[] | cdktf.IResolvable;
}
export interface FederatedSettingsOrgRoleMappingRoleAssignments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_role_mapping#group_id FederatedSettingsOrgRoleMapping#group_id}
    */
    readonly groupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_role_mapping#org_id FederatedSettingsOrgRoleMapping#org_id}
    */
    readonly orgId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_role_mapping#roles FederatedSettingsOrgRoleMapping#roles}
    */
    readonly roles?: string[];
}
export declare function federatedSettingsOrgRoleMappingRoleAssignmentsToTerraform(struct?: FederatedSettingsOrgRoleMappingRoleAssignments | cdktf.IResolvable): any;
export declare class FederatedSettingsOrgRoleMappingRoleAssignmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FederatedSettingsOrgRoleMappingRoleAssignments | cdktf.IResolvable | undefined;
    set internalValue(value: FederatedSettingsOrgRoleMappingRoleAssignments | cdktf.IResolvable | undefined);
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    resetGroupId(): void;
    get groupIdInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    resetOrgId(): void;
    get orgIdInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
}
export declare class FederatedSettingsOrgRoleMappingRoleAssignmentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FederatedSettingsOrgRoleMappingRoleAssignments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FederatedSettingsOrgRoleMappingRoleAssignmentsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_role_mapping mongodbatlas_federated_settings_org_role_mapping}
*/
export declare class FederatedSettingsOrgRoleMapping extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_federated_settings_org_role_mapping";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/federated_settings_org_role_mapping mongodbatlas_federated_settings_org_role_mapping} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FederatedSettingsOrgRoleMappingConfig
    */
    constructor(scope: Construct, id: string, config: FederatedSettingsOrgRoleMappingConfig);
    private _externalGroupName?;
    get externalGroupName(): string;
    set externalGroupName(value: string);
    get externalGroupNameInput(): string | undefined;
    private _federationSettingsId?;
    get federationSettingsId(): string;
    set federationSettingsId(value: string);
    get federationSettingsIdInput(): string | undefined;
    get id(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _roleAssignments;
    get roleAssignments(): FederatedSettingsOrgRoleMappingRoleAssignmentsList;
    putRoleAssignments(value: FederatedSettingsOrgRoleMappingRoleAssignments[] | cdktf.IResolvable): void;
    get roleAssignmentsInput(): cdktf.IResolvable | FederatedSettingsOrgRoleMappingRoleAssignments[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
