import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GlobalClusterConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#cluster_name GlobalClusterConfig#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#id GlobalClusterConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#project_id GlobalClusterConfig#project_id}
    */
    readonly projectId: string;
    /**
    * custom_zone_mappings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#custom_zone_mappings GlobalClusterConfig#custom_zone_mappings}
    */
    readonly customZoneMappings?: GlobalClusterConfigCustomZoneMappings[] | cdktf.IResolvable;
    /**
    * managed_namespaces block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#managed_namespaces GlobalClusterConfig#managed_namespaces}
    */
    readonly managedNamespaces?: GlobalClusterConfigManagedNamespaces[] | cdktf.IResolvable;
}
export interface GlobalClusterConfigCustomZoneMappings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#location GlobalClusterConfig#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#zone GlobalClusterConfig#zone}
    */
    readonly zone?: string;
}
export declare function globalClusterConfigCustomZoneMappingsToTerraform(struct?: GlobalClusterConfigCustomZoneMappings | cdktf.IResolvable): any;
export declare class GlobalClusterConfigCustomZoneMappingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GlobalClusterConfigCustomZoneMappings | cdktf.IResolvable | undefined;
    set internalValue(value: GlobalClusterConfigCustomZoneMappings | cdktf.IResolvable | undefined);
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export declare class GlobalClusterConfigCustomZoneMappingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GlobalClusterConfigCustomZoneMappings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GlobalClusterConfigCustomZoneMappingsOutputReference;
}
export interface GlobalClusterConfigManagedNamespaces {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#collection GlobalClusterConfig#collection}
    */
    readonly collection: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#custom_shard_key GlobalClusterConfig#custom_shard_key}
    */
    readonly customShardKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#db GlobalClusterConfig#db}
    */
    readonly db: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#is_custom_shard_key_hashed GlobalClusterConfig#is_custom_shard_key_hashed}
    */
    readonly isCustomShardKeyHashed?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config#is_shard_key_unique GlobalClusterConfig#is_shard_key_unique}
    */
    readonly isShardKeyUnique?: boolean | cdktf.IResolvable;
}
export declare function globalClusterConfigManagedNamespacesToTerraform(struct?: GlobalClusterConfigManagedNamespaces | cdktf.IResolvable): any;
export declare class GlobalClusterConfigManagedNamespacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GlobalClusterConfigManagedNamespaces | cdktf.IResolvable | undefined;
    set internalValue(value: GlobalClusterConfigManagedNamespaces | cdktf.IResolvable | undefined);
    private _collection?;
    get collection(): string;
    set collection(value: string);
    get collectionInput(): string | undefined;
    private _customShardKey?;
    get customShardKey(): string;
    set customShardKey(value: string);
    get customShardKeyInput(): string | undefined;
    private _db?;
    get db(): string;
    set db(value: string);
    get dbInput(): string | undefined;
    private _isCustomShardKeyHashed?;
    get isCustomShardKeyHashed(): boolean | cdktf.IResolvable;
    set isCustomShardKeyHashed(value: boolean | cdktf.IResolvable);
    resetIsCustomShardKeyHashed(): void;
    get isCustomShardKeyHashedInput(): boolean | cdktf.IResolvable | undefined;
    private _isShardKeyUnique?;
    get isShardKeyUnique(): boolean | cdktf.IResolvable;
    set isShardKeyUnique(value: boolean | cdktf.IResolvable);
    resetIsShardKeyUnique(): void;
    get isShardKeyUniqueInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GlobalClusterConfigManagedNamespacesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GlobalClusterConfigManagedNamespaces[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GlobalClusterConfigManagedNamespacesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config mongodbatlas_global_cluster_config}
*/
export declare class GlobalClusterConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_global_cluster_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/global_cluster_config mongodbatlas_global_cluster_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GlobalClusterConfigConfig
    */
    constructor(scope: Construct, id: string, config: GlobalClusterConfigConfig);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _customZoneMapping;
    get customZoneMapping(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _customZoneMappings;
    get customZoneMappings(): GlobalClusterConfigCustomZoneMappingsList;
    putCustomZoneMappings(value: GlobalClusterConfigCustomZoneMappings[] | cdktf.IResolvable): void;
    resetCustomZoneMappings(): void;
    get customZoneMappingsInput(): cdktf.IResolvable | GlobalClusterConfigCustomZoneMappings[] | undefined;
    private _managedNamespaces;
    get managedNamespaces(): GlobalClusterConfigManagedNamespacesList;
    putManagedNamespaces(value: GlobalClusterConfigManagedNamespaces[] | cdktf.IResolvable): void;
    resetManagedNamespaces(): void;
    get managedNamespacesInput(): cdktf.IResolvable | GlobalClusterConfigManagedNamespaces[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
