import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LdapConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#authentication_enabled LdapConfiguration#authentication_enabled}
    */
    readonly authenticationEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#authorization_enabled LdapConfiguration#authorization_enabled}
    */
    readonly authorizationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#authz_query_template LdapConfiguration#authz_query_template}
    */
    readonly authzQueryTemplate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#bind_password LdapConfiguration#bind_password}
    */
    readonly bindPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#bind_username LdapConfiguration#bind_username}
    */
    readonly bindUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#ca_certificate LdapConfiguration#ca_certificate}
    */
    readonly caCertificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#hostname LdapConfiguration#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#id LdapConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#port LdapConfiguration#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#project_id LdapConfiguration#project_id}
    */
    readonly projectId: string;
    /**
    * user_to_dn_mapping block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#user_to_dn_mapping LdapConfiguration#user_to_dn_mapping}
    */
    readonly userToDnMapping?: LdapConfigurationUserToDnMapping[] | cdktf.IResolvable;
}
export interface LdapConfigurationUserToDnMapping {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#ldap_query LdapConfiguration#ldap_query}
    */
    readonly ldapQuery?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#match LdapConfiguration#match}
    */
    readonly match?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration#substitution LdapConfiguration#substitution}
    */
    readonly substitution?: string;
}
export declare function ldapConfigurationUserToDnMappingToTerraform(struct?: LdapConfigurationUserToDnMapping | cdktf.IResolvable): any;
export declare class LdapConfigurationUserToDnMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LdapConfigurationUserToDnMapping | cdktf.IResolvable | undefined;
    set internalValue(value: LdapConfigurationUserToDnMapping | cdktf.IResolvable | undefined);
    private _ldapQuery?;
    get ldapQuery(): string;
    set ldapQuery(value: string);
    resetLdapQuery(): void;
    get ldapQueryInput(): string | undefined;
    private _match?;
    get match(): string;
    set match(value: string);
    resetMatch(): void;
    get matchInput(): string | undefined;
    private _substitution?;
    get substitution(): string;
    set substitution(value: string);
    resetSubstitution(): void;
    get substitutionInput(): string | undefined;
}
export declare class LdapConfigurationUserToDnMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LdapConfigurationUserToDnMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LdapConfigurationUserToDnMappingOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration mongodbatlas_ldap_configuration}
*/
export declare class LdapConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_ldap_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_configuration mongodbatlas_ldap_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LdapConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: LdapConfigurationConfig);
    private _authenticationEnabled?;
    get authenticationEnabled(): boolean | cdktf.IResolvable;
    set authenticationEnabled(value: boolean | cdktf.IResolvable);
    get authenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _authorizationEnabled?;
    get authorizationEnabled(): boolean | cdktf.IResolvable;
    set authorizationEnabled(value: boolean | cdktf.IResolvable);
    resetAuthorizationEnabled(): void;
    get authorizationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _authzQueryTemplate?;
    get authzQueryTemplate(): string;
    set authzQueryTemplate(value: string);
    resetAuthzQueryTemplate(): void;
    get authzQueryTemplateInput(): string | undefined;
    private _bindPassword?;
    get bindPassword(): string;
    set bindPassword(value: string);
    get bindPasswordInput(): string | undefined;
    private _bindUsername?;
    get bindUsername(): string;
    set bindUsername(value: string);
    get bindUsernameInput(): string | undefined;
    private _caCertificate?;
    get caCertificate(): string;
    set caCertificate(value: string);
    resetCaCertificate(): void;
    get caCertificateInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _userToDnMapping;
    get userToDnMapping(): LdapConfigurationUserToDnMappingList;
    putUserToDnMapping(value: LdapConfigurationUserToDnMapping[] | cdktf.IResolvable): void;
    resetUserToDnMapping(): void;
    get userToDnMappingInput(): cdktf.IResolvable | LdapConfigurationUserToDnMapping[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
