import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LdapVerifyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_verify#authz_query_template LdapVerify#authz_query_template}
    */
    readonly authzQueryTemplate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_verify#bind_password LdapVerify#bind_password}
    */
    readonly bindPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_verify#bind_username LdapVerify#bind_username}
    */
    readonly bindUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_verify#ca_certificate LdapVerify#ca_certificate}
    */
    readonly caCertificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_verify#hostname LdapVerify#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_verify#id LdapVerify#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_verify#port LdapVerify#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_verify#project_id LdapVerify#project_id}
    */
    readonly projectId: string;
}
export interface LdapVerifyLinks {
}
export declare function ldapVerifyLinksToTerraform(struct?: LdapVerifyLinks): any;
export declare class LdapVerifyLinksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LdapVerifyLinks | undefined;
    set internalValue(value: LdapVerifyLinks | undefined);
    get href(): string;
    get rel(): string;
}
export declare class LdapVerifyLinksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LdapVerifyLinksOutputReference;
}
export interface LdapVerifyValidations {
}
export declare function ldapVerifyValidationsToTerraform(struct?: LdapVerifyValidations): any;
export declare class LdapVerifyValidationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LdapVerifyValidations | undefined;
    set internalValue(value: LdapVerifyValidations | undefined);
    get status(): string;
    get validationType(): string;
}
export declare class LdapVerifyValidationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LdapVerifyValidationsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_verify mongodbatlas_ldap_verify}
*/
export declare class LdapVerify extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_ldap_verify";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/ldap_verify mongodbatlas_ldap_verify} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LdapVerifyConfig
    */
    constructor(scope: Construct, id: string, config: LdapVerifyConfig);
    private _authzQueryTemplate?;
    get authzQueryTemplate(): string;
    set authzQueryTemplate(value: string);
    resetAuthzQueryTemplate(): void;
    get authzQueryTemplateInput(): string | undefined;
    private _bindPassword?;
    get bindPassword(): string;
    set bindPassword(value: string);
    get bindPasswordInput(): string | undefined;
    private _bindUsername?;
    get bindUsername(): string;
    set bindUsername(value: string);
    get bindUsernameInput(): string | undefined;
    private _caCertificate?;
    get caCertificate(): string;
    set caCertificate(value: string);
    resetCaCertificate(): void;
    get caCertificateInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _links;
    get links(): LdapVerifyLinksList;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get requestId(): string;
    get status(): string;
    private _validations;
    get validations(): LdapVerifyValidationsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
