import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MaintenanceWindowConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/maintenance_window#auto_defer MaintenanceWindow#auto_defer}
    */
    readonly autoDefer?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/maintenance_window#auto_defer_once_enabled MaintenanceWindow#auto_defer_once_enabled}
    */
    readonly autoDeferOnceEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/maintenance_window#day_of_week MaintenanceWindow#day_of_week}
    */
    readonly dayOfWeek?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/maintenance_window#defer MaintenanceWindow#defer}
    */
    readonly defer?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/maintenance_window#hour_of_day MaintenanceWindow#hour_of_day}
    */
    readonly hourOfDay?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/maintenance_window#id MaintenanceWindow#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/maintenance_window#number_of_deferrals MaintenanceWindow#number_of_deferrals}
    */
    readonly numberOfDeferrals?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/maintenance_window#project_id MaintenanceWindow#project_id}
    */
    readonly projectId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/maintenance_window mongodbatlas_maintenance_window}
*/
export declare class MaintenanceWindow extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_maintenance_window";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/maintenance_window mongodbatlas_maintenance_window} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MaintenanceWindowConfig
    */
    constructor(scope: Construct, id: string, config: MaintenanceWindowConfig);
    private _autoDefer?;
    get autoDefer(): boolean | cdktf.IResolvable;
    set autoDefer(value: boolean | cdktf.IResolvable);
    resetAutoDefer(): void;
    get autoDeferInput(): boolean | cdktf.IResolvable | undefined;
    private _autoDeferOnceEnabled?;
    get autoDeferOnceEnabled(): boolean | cdktf.IResolvable;
    set autoDeferOnceEnabled(value: boolean | cdktf.IResolvable);
    resetAutoDeferOnceEnabled(): void;
    get autoDeferOnceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dayOfWeek?;
    get dayOfWeek(): number;
    set dayOfWeek(value: number);
    resetDayOfWeek(): void;
    get dayOfWeekInput(): number | undefined;
    private _defer?;
    get defer(): boolean | cdktf.IResolvable;
    set defer(value: boolean | cdktf.IResolvable);
    resetDefer(): void;
    get deferInput(): boolean | cdktf.IResolvable | undefined;
    private _hourOfDay?;
    get hourOfDay(): number;
    set hourOfDay(value: number);
    resetHourOfDay(): void;
    get hourOfDayInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _numberOfDeferrals?;
    get numberOfDeferrals(): number;
    set numberOfDeferrals(value: number);
    resetNumberOfDeferrals(): void;
    get numberOfDeferralsInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get startAsap(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
