import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#accepter_region_name NetworkPeering#accepter_region_name}
    */
    readonly accepterRegionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#atlas_cidr_block NetworkPeering#atlas_cidr_block}
    */
    readonly atlasCidrBlock?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#atlas_gcp_project_id NetworkPeering#atlas_gcp_project_id}
    */
    readonly atlasGcpProjectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#atlas_vpc_name NetworkPeering#atlas_vpc_name}
    */
    readonly atlasVpcName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#aws_account_id NetworkPeering#aws_account_id}
    */
    readonly awsAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#azure_directory_id NetworkPeering#azure_directory_id}
    */
    readonly azureDirectoryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#azure_subscription_id NetworkPeering#azure_subscription_id}
    */
    readonly azureSubscriptionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#container_id NetworkPeering#container_id}
    */
    readonly containerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#gcp_project_id NetworkPeering#gcp_project_id}
    */
    readonly gcpProjectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#id NetworkPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#network_name NetworkPeering#network_name}
    */
    readonly networkName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#project_id NetworkPeering#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#provider_name NetworkPeering#provider_name}
    */
    readonly providerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#resource_group_name NetworkPeering#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#route_table_cidr_block NetworkPeering#route_table_cidr_block}
    */
    readonly routeTableCidrBlock?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#vnet_name NetworkPeering#vnet_name}
    */
    readonly vnetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering#vpc_id NetworkPeering#vpc_id}
    */
    readonly vpcId?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering mongodbatlas_network_peering}
*/
export declare class NetworkPeering extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_network_peering";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/network_peering mongodbatlas_network_peering} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkPeeringConfig
    */
    constructor(scope: Construct, id: string, config: NetworkPeeringConfig);
    private _accepterRegionName?;
    get accepterRegionName(): string;
    set accepterRegionName(value: string);
    resetAccepterRegionName(): void;
    get accepterRegionNameInput(): string | undefined;
    private _atlasCidrBlock?;
    get atlasCidrBlock(): string;
    set atlasCidrBlock(value: string);
    resetAtlasCidrBlock(): void;
    get atlasCidrBlockInput(): string | undefined;
    private _atlasGcpProjectId?;
    get atlasGcpProjectId(): string;
    set atlasGcpProjectId(value: string);
    resetAtlasGcpProjectId(): void;
    get atlasGcpProjectIdInput(): string | undefined;
    get atlasId(): string;
    private _atlasVpcName?;
    get atlasVpcName(): string;
    set atlasVpcName(value: string);
    resetAtlasVpcName(): void;
    get atlasVpcNameInput(): string | undefined;
    private _awsAccountId?;
    get awsAccountId(): string;
    set awsAccountId(value: string);
    resetAwsAccountId(): void;
    get awsAccountIdInput(): string | undefined;
    private _azureDirectoryId?;
    get azureDirectoryId(): string;
    set azureDirectoryId(value: string);
    resetAzureDirectoryId(): void;
    get azureDirectoryIdInput(): string | undefined;
    private _azureSubscriptionId?;
    get azureSubscriptionId(): string;
    set azureSubscriptionId(value: string);
    resetAzureSubscriptionId(): void;
    get azureSubscriptionIdInput(): string | undefined;
    get connectionId(): string;
    private _containerId?;
    get containerId(): string;
    set containerId(value: string);
    get containerIdInput(): string | undefined;
    get errorMessage(): string;
    get errorState(): string;
    get errorStateName(): string;
    private _gcpProjectId?;
    get gcpProjectId(): string;
    set gcpProjectId(value: string);
    resetGcpProjectId(): void;
    get gcpProjectIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _networkName?;
    get networkName(): string;
    set networkName(value: string);
    resetNetworkName(): void;
    get networkNameInput(): string | undefined;
    get peerId(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _routeTableCidrBlock?;
    get routeTableCidrBlock(): string;
    set routeTableCidrBlock(value: string);
    resetRouteTableCidrBlock(): void;
    get routeTableCidrBlockInput(): string | undefined;
    get status(): string;
    get statusName(): string;
    private _vnetName?;
    get vnetName(): string;
    set vnetName(value: string);
    resetVnetName(): void;
    get vnetNameInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    resetVpcId(): void;
    get vpcIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
