import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OnlineArchiveConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#cluster_name OnlineArchive#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#coll_name OnlineArchive#coll_name}
    */
    readonly collName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#collection_type OnlineArchive#collection_type}
    */
    readonly collectionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#db_name OnlineArchive#db_name}
    */
    readonly dbName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#id OnlineArchive#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#paused OnlineArchive#paused}
    */
    readonly paused?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#project_id OnlineArchive#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#sync_creation OnlineArchive#sync_creation}
    */
    readonly syncCreation?: boolean | cdktf.IResolvable;
    /**
    * criteria block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#criteria OnlineArchive#criteria}
    */
    readonly criteria: OnlineArchiveCriteria;
    /**
    * partition_fields block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#partition_fields OnlineArchive#partition_fields}
    */
    readonly partitionFields?: OnlineArchivePartitionFields[] | cdktf.IResolvable;
}
export interface OnlineArchiveCriteria {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#date_field OnlineArchive#date_field}
    */
    readonly dateField?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#date_format OnlineArchive#date_format}
    */
    readonly dateFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#expire_after_days OnlineArchive#expire_after_days}
    */
    readonly expireAfterDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#query OnlineArchive#query}
    */
    readonly query?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#type OnlineArchive#type}
    */
    readonly type: string;
}
export declare function onlineArchiveCriteriaToTerraform(struct?: OnlineArchiveCriteriaOutputReference | OnlineArchiveCriteria): any;
export declare class OnlineArchiveCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OnlineArchiveCriteria | undefined;
    set internalValue(value: OnlineArchiveCriteria | undefined);
    private _dateField?;
    get dateField(): string;
    set dateField(value: string);
    resetDateField(): void;
    get dateFieldInput(): string | undefined;
    private _dateFormat?;
    get dateFormat(): string;
    set dateFormat(value: string);
    resetDateFormat(): void;
    get dateFormatInput(): string | undefined;
    private _expireAfterDays?;
    get expireAfterDays(): number;
    set expireAfterDays(value: number);
    resetExpireAfterDays(): void;
    get expireAfterDaysInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    resetQuery(): void;
    get queryInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface OnlineArchivePartitionFields {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#field_name OnlineArchive#field_name}
    */
    readonly fieldName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive#order OnlineArchive#order}
    */
    readonly order: number;
}
export declare function onlineArchivePartitionFieldsToTerraform(struct?: OnlineArchivePartitionFields | cdktf.IResolvable): any;
export declare class OnlineArchivePartitionFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OnlineArchivePartitionFields | cdktf.IResolvable | undefined;
    set internalValue(value: OnlineArchivePartitionFields | cdktf.IResolvable | undefined);
    private _fieldName?;
    get fieldName(): string;
    set fieldName(value: string);
    get fieldNameInput(): string | undefined;
    get fieldType(): string;
    private _order?;
    get order(): number;
    set order(value: number);
    get orderInput(): number | undefined;
}
export declare class OnlineArchivePartitionFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OnlineArchivePartitionFields[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OnlineArchivePartitionFieldsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive mongodbatlas_online_archive}
*/
export declare class OnlineArchive extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_online_archive";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/online_archive mongodbatlas_online_archive} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OnlineArchiveConfig
    */
    constructor(scope: Construct, id: string, config: OnlineArchiveConfig);
    get archiveId(): string;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _collName?;
    get collName(): string;
    set collName(value: string);
    get collNameInput(): string | undefined;
    private _collectionType?;
    get collectionType(): string;
    set collectionType(value: string);
    resetCollectionType(): void;
    get collectionTypeInput(): string | undefined;
    private _dbName?;
    get dbName(): string;
    set dbName(value: string);
    get dbNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _paused?;
    get paused(): boolean | cdktf.IResolvable;
    set paused(value: boolean | cdktf.IResolvable);
    resetPaused(): void;
    get pausedInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get state(): string;
    private _syncCreation?;
    get syncCreation(): boolean | cdktf.IResolvable;
    set syncCreation(value: boolean | cdktf.IResolvable);
    resetSyncCreation(): void;
    get syncCreationInput(): boolean | cdktf.IResolvable | undefined;
    private _criteria;
    get criteria(): OnlineArchiveCriteriaOutputReference;
    putCriteria(value: OnlineArchiveCriteria): void;
    get criteriaInput(): OnlineArchiveCriteria | undefined;
    private _partitionFields;
    get partitionFields(): OnlineArchivePartitionFieldsList;
    putPartitionFields(value: OnlineArchivePartitionFields[] | cdktf.IResolvable): void;
    resetPartitionFields(): void;
    get partitionFieldsInput(): cdktf.IResolvable | OnlineArchivePartitionFields[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
