import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrgInvitationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/org_invitation#id OrgInvitation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/org_invitation#org_id OrgInvitation#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/org_invitation#roles OrgInvitation#roles}
    */
    readonly roles: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/org_invitation#teams_ids OrgInvitation#teams_ids}
    */
    readonly teamsIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/org_invitation#username OrgInvitation#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/org_invitation mongodbatlas_org_invitation}
*/
export declare class OrgInvitation extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_org_invitation";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/org_invitation mongodbatlas_org_invitation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrgInvitationConfig
    */
    constructor(scope: Construct, id: string, config: OrgInvitationConfig);
    get createdAt(): string;
    get expiresAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get invitationId(): string;
    get inviterUsername(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    get rolesInput(): string[] | undefined;
    private _teamsIds?;
    get teamsIds(): string[];
    set teamsIds(value: string[]);
    resetTeamsIds(): void;
    get teamsIdsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
